package com.bokesoft.yigo.meta.form.component.control;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaImageListItem extends KeyPairMetaObject{
	
	public static final String TAG_NAME = "ImageItem";
	/** 选项值，作为标识使用*/
	private String value = "";
	/** 本地图片相对路径*/
	private String image = "";
	
	@Override
	public String getKey() {
		return value;
	}
	
	public String getValue() {
		return value;
	}
	
	public void setValue(String value) {
		this.value = value;
	}
	
	public String getImage() {
		return image;
	}
	
	public void setImage(String image) {
		this.image = image;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaImageListItem item = (MetaImageListItem)newInstance();
		item.setImage(image);
		item.setValue(value);
		return item;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaImageListItem();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

}
