package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaIconProperties;

public class MetaIcon extends MetaComponent {

	private MetaIconProperties properties = new MetaIconProperties();

	public static final String TAG_NAME = ControlType.STR_ICON;

	@Override
	public int getControlType() {
		return ControlType.ICON;
	}
	
	public String getIcon() {
		return properties.getIcon();
	}

	public void setIcon(String icon) {
		this.properties.setIcon(icon); 
	}
	
	public String getURL() {
		return properties.getUrl();
	}

	public void setURL(String url) {
		this.properties.setIcon(url); 
	}
	
	/**
	 * 获取拉伸缩放类型
	 *
	 * @return 拉伸缩放类型
	 */
	public Integer getImageScaleType() {
		return properties.getImageScaleType();
	}

	/**
	 * 设置拉伸缩放类型
	 *
	 * @param imageScaleType 拉伸缩放类型
	 */
	public void setImageScaleType(Integer imageScaleType) {
		this.properties.setImageScaleType(imageScaleType);
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaIconProperties) properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaIcon();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaIcon newObject = (MetaIcon)super.clone();
		newObject.setProperties((MetaIconProperties)properties.clone());
		return newObject;
	}


}
