package com.bokesoft.yigo.meta.form.component.control;

import java.util.ArrayList;
import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaDrawerBox extends MetaComponent{
	
	public static final String TAG_NAME = ControlType.STR_DRAWERBOX;
	
	/** 子控件集合，包含该控件范围内的所有子控件 */
	private ArrayList<MetaComponent> componentArray = null;
	
	/*** 布局方向*/
	private Integer orientation = OrientationType.Vertical;
	
	/** 是否默认展开 */
	private Boolean isExpand = false;
	
	/** 指示器颜色*/
	private String indicatorBackColor = "";
	

	public MetaDrawerBox() {
		super();
		componentArray = new ArrayList<MetaComponent>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(componentArray);
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject obj = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if(obj != null){
			return obj;
		}
		MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
		control.preProcessMetaObject(env, doc, node, flag, runType);
		this.addComponent(control);
		return control;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		for (MetaComponent metaComponent : componentArray) {
			metaComponent.doPostProcess(flag, callback);
		}
	}
	
	@Override
	public void addComponent(MetaComponent component) {
		componentArray.add(component);
	}
	
	@Override
	public int getComponentCount() {
		return componentArray.size();
	}
	
	@Override
	public MetaComponent getComponent(int index) {
		return componentArray.get(index);
	}
	
	@Override
	public int getControlType() {
		return ControlType.DRAWERBOX;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getTagName() {
		return ControlType.STR_DRAWERBOX;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDrawerBox();
	}
	
	/** 
	 * 获取布局方向
	 * @return 布局方向
	 */
	public final Integer getOrientation() {
		return orientation;
	}

	/**
	 * 设置布局方向
	 * @param orientation 设置布局方向
	 */
	public final void setOrientation(Integer orientation) {
		this.orientation = orientation;
	}
	
	public Boolean getIsExpand() {
		return isExpand;
	}

	public void setIsExpand(Boolean isExpand) {
		this.isExpand = isExpand;
	}
	
	public String getIndicatorBackColor() {
		return indicatorBackColor;
	}

	public void setIndicatorBackColor(String indicatorBackColor) {
		this.indicatorBackColor = indicatorBackColor;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDrawerBox drawerBox = (MetaDrawerBox)super.clone();
		drawerBox.setOrientation(orientation);
		for (MetaComponent metaComponent : componentArray) {
			drawerBox.addComponent(metaComponent);
		}
		return drawerBox;
	}
}