package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;

/**
 * 按钮配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaButton extends MetaComponent {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_BUTTON;
	protected MetaButtonProperties properties;

	public MetaButton(){
		properties = newProperties();
	}

	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		properties.setOnClick(onClick);
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return properties.getOnClick();
	}

	/**
	 * 设置按钮图标
	 * @param icon 图标
	 */
	public void setIcon(String icon) {
		this.properties.setIcon(icon);
	}
	
	/**
	 * 取得按钮图标
	 * @return 图标
	 */
	public String getIcon() {
		return this.properties.getIcon();
	}
	
	/**
	 * 设置图标位置
	 * 
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation){
		this.properties.setIconLocation(iconLocation);
	}
	
	/**
	 * 获取图标位置
	 * 
	 * @return 图标位置
	 */
	public Integer getIconLocation(){
		return this.properties.getIconLocation();
	}
	
	/**
	 * 设置仅显示图标
	 * @param onlyIcon 仅显示图标
	 */
	public void setOnlyIcon(Boolean onlyIcon){
		this.properties.setOnlyIcon(onlyIcon);
	}
	
	/**
	 * 获取仅显示图标
	 * @return 仅显示图标
	 */
	public Boolean isOnlyIcon(){
		return this.properties.isOnlyIcon();
	}
	

	/**
	 * 设置是否需要认证标志
	 * @param needAuthenticate 是否需要认证标志
	 */
	public void setNeedAuthenticate(Boolean needAuthenticate) {
		properties.setNeedAuthenticate(needAuthenticate);
	}
	
	/**
	 * 获取是否需要认证标志
	 * @return 是否需要认证标志
	 */
	public Boolean isNeedAuthenticate() {
		return properties.isNeedAuthenticate();
	}

	/**
	 * 设置点击动画，目前只支持TabGroup，ImageButton 和 Button，其他组件不支持
	 * @param clickAnim 点击动画类型，参考{@link com.bokesoft.yigo.common.def.ClickAnim}
	 */
	public void setClickAnim(String clickAnim) {
		properties.setClickAnim(clickAnim);
	}
	
	/**
	 * 获取点击动画，目前只支持TabGroup，ImageButton 和 Button，其他组件不支持
	 * @return 点击动画类型，参考{@link com.bokesoft.yigo.common.def.ClickAnim}
	 */
	public String getClickAnim() {
		return properties.getClickAnim();
	}
	
	/**
	 * 获取按钮类型
	 * @return 按钮类型
	 */
	public Integer getType() {
		return properties.getType();
	}

	/**
	 * 设置按钮类型
	 * @param type 按钮类型
	 */
	public void setType(Integer type) {
		properties.setType(type);
	}
	
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaButtonProperties) properties;
	}
	
	@Override
	public MetaButtonProperties getProperties() {
		return this.properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.BUTTON;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaButton newObject = (MetaButton)super.clone();
		newObject.setProperties((MetaButtonProperties)properties.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaButton();
	}
	
	public MetaButtonProperties newProperties(){
		return new MetaButtonProperties();
	}
}
