package com.bokesoft.yigo.meta.form.component;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaVar;

/**
 * MetaEmbed定义嵌入组件，嵌入组件指将模板表单中的某个组件及子组件嵌入到目标表单中
 * @author wangyh
 *
 */
public class MetaEmbed extends MetaComponent {
	/** 表单标识 */
	private String formKey = "";
	/** 根组件标识 */
	private String rootKey = "";
	/** 嵌入数据表标志 */
	private Boolean includeDataTable = true;
	/** 变量集合 */
	private MetaEmbedVarCollection vars;
	
	public MetaEmbed() {
		super();
		vars = new MetaEmbedVarCollection();
	}
	
	@Override
	public int getControlType() {
		return ControlType.EMBED;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return null;
	}

	public static final String TAG_NAME = ControlType.STR_EMBED;
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEmbed();
	}

	/**
	 * 设置表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	/**
	 * 取得表单标识
	 * @return 表单标识
	 */
	public String getFormKey() {
		return this.formKey;
	}
	
	/**
	 * 设置根组件标识
	 * @param rootKey 根组件标识
	 */
	public void setRootKey(String rootKey) {
		this.rootKey = rootKey;
	}
	
	/**
	 * 取得根组件标识
	 * @return 根组件标识
	 */
	public String getRootKey() {
		return this.rootKey;
	}
	
	/**
	 * 设置是否包含数据表标志
	 * @param includeDataTable 标志
	 */
	public void setIncludeDataTable(Boolean includeDataTable) {
		this.includeDataTable = includeDataTable;
	}
	
	/**
	 * 取得是否包含数据表标志
	 * @return 标志
	 */
	public Boolean isIncludeDataTable() {
		return this.includeDataTable;
	}
	
	/**
	 * 设置变量集合
	 * @param vars 变量集合
	 */
	public void setVars(MetaEmbedVarCollection vars) {
		this.vars = vars;
	}
	
	/**
	 * 取得变量集合
	 * @return 变量集合
	 */
	public MetaEmbedVarCollection getVars() {
		return this.vars;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(vars);
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			resultMetaObject = vars.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaEmbed newObject = (MetaEmbed)super.clone();
		newObject.setFormKey(formKey);
		newObject.setRootKey(rootKey);
		newObject.setIncludeDataTable(includeDataTable);
		newObject.setVars(vars == null ? null : (MetaEmbedVarCollection)vars.clone());
		
		return newObject;
	}
	
	@Override
	public void merge(MetaComponent meta) {
		super.merge(meta);
		
		MetaEmbed embed = (MetaEmbed)meta;
		
		if( this.formKey == null ) {
			this.formKey = embed.getFormKey();
		}
		if( this.rootKey == null ) {
			this.rootKey = embed.getRootKey();
		}
		if( this.includeDataTable == null ) {
			this.includeDataTable = embed.isIncludeDataTable();
		}
		MetaEmbedVarCollection vcs = embed.getVars();
		if( vcs != null ) {
			if( this.vars == null ) {
				this.vars = (MetaEmbedVarCollection) vcs.clone();
			} else {
				for (MetaVar vc : vcs) {
					if (this.vars.containsKey(vc.getKey())){
						this.vars.get(vc.getKey()).merge(vc);
					}else {
						this.vars.add(vc);
					}
				}
			}
		}
	}

}
