package com.bokesoft.yigo.meta.form.anim;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 动画属性配置对象
 * @author chenzs
 *
 */
public class MetaAnimProperty extends KeyPairMetaObject{

	public static final String TAG_NAME = "AnimProperty";
	
	/** 属性名称标识 */
	private String key = "";
	
	/** 属性值*/
	private String value = "";
	
	@Override
	public String getKey() {
		return key;
	}
	
	/**
	 * 设置属性名称标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取属性值
	 * @return 属性值
	 */
	public String getValue() {
		return value;
	}
	
	/**
	 * 设置属性值
	 * @param value 属性值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaAnimProperty newObject = new MetaAnimProperty();
		newObject.setKey(key);
		newObject.setValue(value);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAnimProperty();
	}
}
