package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaTableBinding extends GenericKeyCollectionWithKey<MetaColumnBinding> {
	/** 表标识 */
	private String key = "";
	
	public MetaTableBinding() {
		super();
	}
	
	/**
	 * 设置表标识
	 * @param key 表标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "TableBinding";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		MetaColumnBinding resultMetaObject = null;
		if ( MetaColumnBinding.TAG_NAME.equals(tagName) ) {
			MetaColumnBinding columnBinding = new MetaColumnBinding();
			columnBinding.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(columnBinding);
			resultMetaObject = columnBinding;
		}
		return resultMetaObject;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaTableBinding newObject = (MetaTableBinding)super.clone();
		newObject.setKey(key);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableBinding();
	}

}
