package com.bokesoft.yigo.meta.form;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFormPara extends AbstractMetaObject implements IPropertyMerger<MetaFormPara> {
	/** 参数标识 */
	private String key = "";
	/** 参数来源类型 */
	private Integer type = -1;
	/** 表达式 */
	private String formula = "";
	/** 常量值 */
	private String value = "";
	/** 数值类型 */
	private Integer dataType = -1;
	/** 共享至中间层 */
	private Boolean shareToMid = true;
	/** 值依赖 */
	private String dependency = "";
	/** 处理后的依赖集合*/
	private List<String> dependentFields = null;
	
	public MetaFormPara() {
		super();
		this.dependentFields = new ArrayList<String>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "FormPara";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}
	
	/**
	 * 设置参数标识
	 * @param key 参数标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得参数标识
	 * @return 参数标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置参数来源类型
	 * @param type 参数来源类型
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得参数来源类型
	 * @return 参数来源类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置表达式
	 * @param formula 表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public String getFormula() {
		return this.formula;
	}
	
	/**
	 * 设置常量值
	 * @param value 常量值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * 取得常量值
	 * @return 常量值
	 */
	public String getValue() {
		return this.value;
	}
	
	/**
	 * 设置数据类型
	 * @param dataType 数据类型
	 */
	public void setDataType(Integer dataType) {
		this.dataType = dataType;
	}
	
	/**
	 * 取得数据类型
	 * @return 数据类型
	 */
	public Integer getDataType() {
		return this.dataType;
	}
	
	/**
	 * 设置是否共享至中间层
	 * @param shareToMid 标志
	 */
	public void setShareToMid(Boolean shareToMid) {
		this.shareToMid = shareToMid;
	}
	
	/**
	 * 取得是否共享至中间层标志
	 * @return 标志
	 */
	public Boolean isShareToMid() {
		return this.shareToMid;
	}
	
	/**
	 * 设置依赖
	 * @param dependency 依赖
	 */
	public void setDependency(String dependency) {
		this.dependency = dependency;
		
		if( dependency != null && !dependency.isEmpty() ) {
			String[] fields = this.dependency.split(",");
			for(String field : fields){
				dependentFields.add(field);
			}
		}
	}
	
	public List<String> getDependentFields() {
		return dependentFields;
	}

	/**
	 * 取得依赖
	 * @return 依赖
	 */
	public String getDependency() {
		return this.dependency;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFormPara newObject = (MetaFormPara)newInstance();
		newObject.setKey(key);
		newObject.setType(type);
		newObject.setFormula(formula);
		newObject.setValue(value);
		newObject.setDataType(dataType);
		newObject.setShareToMid(shareToMid);
		newObject.setDependency(dependency);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFormPara();
	}
	
	@Override
	public boolean needCheckExtend() {
		return true;
	}

	@Override
	public void merge(MetaFormPara para) {
		if( this.type == -1 ) {
			this.type = para.getType();
		}
		if( this.formula == null ) {
			this.formula = para.getFormula();
		}
		if( this.value == null ) {
			this.value = para.getValue();
		}
		if( this.dataType == -1 ) {
			this.dataType = para.getDataType();
		}
		if( this.shareToMid == null ) {
			this.shareToMid = para.isShareToMid();
		}
		if( this.dependency == null ) {
			this.dependency = para.getDependency();
		}
	}

}
