package com.bokesoft.yigo.meta.form;

import com.bokesoft.yigo.common.def.AppEventTriggerType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaEventHandler定义事件处理，用于移动平台
 * @author wangyh
 *
 */
public class MetaEventHandler extends MetaBaseScript {
	/** 触发时机 */
	private Integer trigger = AppEventTriggerType.Show;
	/** 合并事件处理标志 */
	private Boolean mergeEvent = false;
	
	public static final String TAG_NAME = "EventHandler";
	
	public MetaEventHandler() {
		super(TAG_NAME);
	}
	
	/**
	 * 设置触发时机
	 * @param trigger 时机
	 */
	public void setTrigger(Integer trigger) {
		this.trigger = trigger;
	}
	
	/**
	 * 取得触发时机
	 * @return 时机
	 */
	public Integer getTrigger() {
		return this.trigger;
	}
	
	/**
	 * 设置合并事件标志
	 * @param mergeEvent 标志
	 */
	public void setMergeEvent(Boolean mergeEvent) {
		this.mergeEvent = mergeEvent;
	}
	
	/**
	 * 取得合并事件标志
	 * @return 标志
	 */
	public Boolean isMergeEvent() {
		return this.mergeEvent;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEventHandler();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaEventHandler newObject = (MetaEventHandler)super.clone();
		newObject.setTrigger(trigger);
		newObject.setMergeEvent(mergeEvent);
		
		return newObject;
	}
	
	@Override
	public boolean needPreLoad() {
		return true;
	}
}
