package com.bokesoft.yigo.meta.exceltemplate;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.report.MetaReportFormat;

public class MetaExcelFormat extends AbstractMetaObject {
	public static final String TAG_NAME = "Format";
	/** 自定义数据类型*/
	private Integer DataType = 1;
	/** 字典标识 */
	private String itemKey = "";
	/** 字段列表 */
	private String fieldKeys = "";
	/** 格式化字符串*/
	private String formatString = "";
	/** 图片类型存储服务 */
	private String storageService = "";

	private List<MetaExcelListItem> listItems = null;

	public MetaExcelFormat() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (listItems != null) {
			list.add(listItems);
		}
	}


	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置字典标识
	 * 
	 * @param itemKey 字典标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}

	/**
	 * 取得字典标识
	 * 
	 * @return 字典标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}

	/**
	 * 设置字段列表
	 * 
	 * @param fieldKeys 字段列表
	 */
	public void setFieldKeys(String fieldKeys) {
		this.fieldKeys = fieldKeys;
	}

	/**
	 * 取得字段列表
	 * 
	 * @return 字段列表
	 */
	public String getFieldKeys() {
		return this.fieldKeys;
	}

	public Integer getDataType() {
		return DataType;
	}

	public void setDataType(Integer dataType) {
		DataType = dataType;
	}

	public String getFormatString() {
		return formatString;
	}

	public void setFormatString(String formatString) {
		this.formatString = formatString;
	}

	public void setListItems(List<MetaExcelListItem> listItems) {
		this.listItems = listItems;
	}
	
	public void addItem(MetaExcelListItem item) {
		if (this.listItems == null) {
			this.listItems = new ArrayList<>();
		}
		this.listItems.add(item);
	}
	
	public String getStorageService() {
		return this.storageService;
	}
	
	public void setStorageService(String storageService) {
		this.storageService = storageService;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaExcelListItem.TAG_NAME.equals(tagName)) {
			MetaExcelListItem listItem = new MetaExcelListItem();
			listItem.preProcessMetaObject(env, doc, node, flag, runType);
			if (this.listItems == null)
				listItems = new ArrayList<MetaExcelListItem>();
			listItems.add(listItem);
			metaObject = listItem;
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportFormat newObject = (MetaReportFormat) newInstance();
		newObject.setItemKey(this.itemKey);
		newObject.setFieldKeys(this.fieldKeys);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportFormat();
	}

	public List<MetaExcelListItem> getListItems() {
		return this.listItems;
	}
}
