package com.bokesoft.yigo.meta.exceltemplate;

/**
 * ExcelTemplateRowType定义Excel模板中行的类型
 * 
 * @since YES 1.0
 *
 */
public class ExcelTemplateRowType {

	/** 表头数据行*/
	public static final int Head = 1;
	public static final String STR_Head = "Head";

	/** 明细头 */
	public static final int DetailHead = 2;
	public static final String STR_DetailHead = "DetailHead";

	/** 明细行 */
	public static final int Detail = 3;
	public static final String STR_Detail = "Detail";
	
	/** 分组汇总行 */
	public static final int Group = 4;
	public static final String STR_Group = "Group";

	/** 表格中的固定行 */
	public static final int Fix = 5;
	public static final String STR_Fix = "Fix";
	
	/** 表格中的汇总行 */
	public static final int Total = 6;
	public static final String STR_Total = "Total";
	
	
	public static int parse(String s) {
		int type = -1;
		if (STR_Head.equalsIgnoreCase(s)) {
			type = Head;
		} else if (STR_DetailHead.equalsIgnoreCase(s)) {
			type = DetailHead;
		} else if (STR_Detail.equalsIgnoreCase(s)) {
			type = Detail;
		} else if (STR_Group.equalsIgnoreCase(s)) {
			type = Group;
		} else if (STR_Fix.equalsIgnoreCase(s)) {
			type = Fix;
		} else if (STR_Total.equalsIgnoreCase(s)) {
			type = Total;
		}
		return type;
	}

	public static String toString(Integer type) {
		if(type == null) {
			return "";
		}
		String s = "";
		switch (type) {
		case Head:
			s = STR_Head;
			break;
		case DetailHead:
			s = STR_DetailHead;
			break;
		case Detail:
			s = STR_Detail;
			break;
		case Group:
			s = STR_Group;
			break;
		case Fix:
			s = STR_Fix;
			break;
		case Total:
			s = STR_Total;
			break;
		}
		return s;
	}
}
