package com.bokesoft.yigo.meta.enhance;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaExtUpdateListener extends GenericNoKeyCollection<MetaUpdateListener> implements IElementMerge<MetaExtUpdateListener> {

	public static final String TAG_NAME = "ExtUpdateListener";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaUpdateListener.TAG_NAME.equals(tagName) ) {
			MetaUpdateListener listener = new MetaUpdateListener();
			this.add(listener);
			resultMetaObject = listener;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtUpdateListener();
	}

	@Override
	public MetaExtUpdateListener toMerge(MetaExtUpdateListener obj) {
		if (obj != null) {
			Iterator<MetaUpdateListener> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaUpdateListener metaUpdateListener = (MetaUpdateListener) iterator.next();
				add(metaUpdateListener);
			}
		}
		return this;
	}

}
