package com.bokesoft.yigo.meta.enhance;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaEnhance extends AbstractMetaObject implements IElementMerge<MetaEnhance> {
	public static final String TAG_NAME = "Enhance";

	/** 额外服务 */
	private MetaExtService metaExtSvr;
	/** 自定义系统服务 */
	private MetaExtSysService metaExtSysSvr;
	/** 扩展中间层函数 */
	private MetaExtMidFunction metaExtMidFunc;
	/** 扩展客户端函数 */
	private MetaExtUIFunction metaExtUIFunc;
	/** 扩展初始化操作 */
	private MetaExtStartListener startListener;
	/** 自定义导入服务*/
	private MetaExtImportService metaExtImportService;
	/** 自定义导出服务*/
	private MetaExtExportService metaExtExportService;
	/** 导出后自定义服务*/
	private MetaExtPostExportService metaExtPostExportService;
	/** 报表的函数扩展 */
	private MetaExtReportFunction metaExtReportFunction = null;
	/** 拓展的热更新操作*/
	private MetaExtUpdateListener updateListener = null;
	/** 自定义数据处理*/
	private MetaExtDataProcess metaExtDataProcess = null;
	/** 自定义上传完成处理（针对于后台的）*/
	private MetaExtAttachmentProcess metaExtAttachmentProcess = null;
	/** 自定义Document载入服务 */
	private MetaExtDocumentService metaExtDocumentService = null;
	
	public MetaEnhance() {
		metaExtSvr = new MetaExtService();
		metaExtMidFunc = new MetaExtMidFunction();
		metaExtUIFunc = new MetaExtUIFunction();
		startListener = new MetaExtStartListener();
		updateListener = new MetaExtUpdateListener();
		metaExtImportService = new MetaExtImportService();
		metaExtSysSvr = new MetaExtSysService();
		metaExtReportFunction = new MetaExtReportFunction();
		metaExtExportService = new MetaExtExportService();
		metaExtPostExportService = new MetaExtPostExportService();
		metaExtDataProcess = new MetaExtDataProcess();
		metaExtDocumentService = new MetaExtDocumentService();
		metaExtAttachmentProcess = new MetaExtAttachmentProcess();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, 
				metaExtSvr, 
				metaExtMidFunc, 
				metaExtUIFunc, 
				startListener, 
				updateListener,
				metaExtImportService, 
				metaExtPostExportService, 
				metaExtSysSvr,
				metaExtExportService,
				metaExtReportFunction,
				metaExtDataProcess,
				metaExtAttachmentProcess,
				metaExtDocumentService
		);
	}
	
	/**
	 * 取得扩展服务
	 * @return 扩展服务
	 */
	public MetaExtService getMetaExtService() {
		return metaExtSvr;
	}

	/**
	 * 设置扩展服务
	 * @param extService 扩展服务
	 */
	public void setMetaExtService(MetaExtService extService) {
		this.metaExtSvr = extService;
	}
	
	/**
	 * 设置导入扩展服务
	 * @param extImportService 导入扩展服务
	 */
	public void setExtImportService(MetaExtImportService extImportService) {
		this.metaExtImportService = extImportService;
	}
	
	/**
	 * 获取导入扩展服务
	 * @return 导入扩展服务
	 */
	public MetaExtImportService getExtImportService() {
		return metaExtImportService;
	}
	
	/**
	 * 设置自定义导出服务
	 * @param extImportService 自定义导出服务
	 */
	public void setExtExportService(MetaExtExportService extExportService) {
		this.metaExtExportService = extExportService;
	}
	
	/**
	 * 获取自定义导出服务
	 * @return 自定义导出服务
	 */
	public MetaExtExportService getExtExportService() {
		return metaExtExportService;
	}

	/**
	 * 设置导出后扩展服务
	 * @param extPostExportService 导出后扩展服务
	 */
	public void setPostExportService(MetaExtPostExportService extPostExportService) {
		this.metaExtPostExportService = extPostExportService;
	}
	
	/**
	 * 获取导出后扩展服务
	 * @return 导出后扩展服务
	 */
	public MetaExtPostExportService getPostExportService() {
		return metaExtPostExportService;
	}
	
	/**
	 * 设置扩展中间层函数
	 * @param extMidFunc 扩展中间层函数
	 */
	public void setMetaExtMidFunction(MetaExtMidFunction extMidFunc) {
		this.metaExtMidFunc = extMidFunc;
	}
	
	/**
	 * 取得扩展中间层函数
	 * @return 扩展中间层函数
	 */
	public MetaExtMidFunction getMetaExtMidFunction() {
		return metaExtMidFunc;
	}

	/**
	 * 设置扩展客户端函数
	 * @param extUIFunc 扩展客户端函数
	 */
	public void setMetaExtUIFunction(MetaExtUIFunction extUIFunc) {
		this.metaExtUIFunc = extUIFunc;
	}
	
	/**
	 * 取得扩展客户端函数
	 * @return 扩展客户端函数
	 */
	public MetaExtUIFunction getMetaExtUIFunction() {
		return metaExtUIFunc;
	}
	
	/**
<<<<<<< .working
	 * 设置应用初始化操作
	 * @param startListener 应用初始化操作
	 */
	public void setMetaExtUIFunction(MetaExtStartListener startListener) {
		this.startListener = startListener;
	}
	
	/**
||||||| .merge-left.r36987
=======
	 * 设置应用初始化操作
	 * @param startListener 应用初始化操作
	 */
	public void setExtStartListener(MetaExtStartListener startListener) {
		this.startListener = startListener;
	}
	
	/**
>>>>>>> .merge-right.r44086
	 * 取得应用初始化操作
	 * @return 应用初始化操作
	 */
	public MetaExtStartListener getStartListener() {
		return this.startListener;
	}

	/**
	 * 设置应用热更新的拓展操作
	 * @param updateListener 应用热更新的拓展操作
	 */
	public void setUpdateListener(MetaExtUpdateListener updateListener) {
		this.updateListener = updateListener;
	}
	
	/**
	 * 取得应用热更新的拓展操作
	 * @return 应用热更新的拓展操作
	 */
	public MetaExtUpdateListener getUpdateListener() {
		return updateListener;
	}

	/**
	 * 设置扩展系统服务
	 * @param extSysSvr 扩展系统服务
	 */
	public void setMetaExtSysSvr(MetaExtSysService extSysSvr) {
		this.metaExtSysSvr = extSysSvr;
	}
	
	/**
	 * 取得扩展系统服务
	 * @return 扩展系统服务
	 */
	public MetaExtSysService getMetaExtSysSvr() {
		return metaExtSysSvr;
	}
	
	/**
	 * 设置自定义数据处理
	 * @param extDataProcess 自定义数据处理
	 */
	public void setExtDataProcess(MetaExtDataProcess extDataProcess) {
		this.metaExtDataProcess = extDataProcess;
	}
	
	/**
	 * 取得自定义数据处理
	 * @return 自定义数据处理
	 */
	public MetaExtDataProcess getMetaExtDataProcess() {
		return metaExtDataProcess;
	}
	
	/**
	 * 设置报表函数扩展
	 * @param metaExtReportFunction 函数扩展定义
	 */
	public void setExtReportFunction(MetaExtReportFunction metaExtReportFunction) {
		this.metaExtReportFunction = metaExtReportFunction;
	}
	
	/**
	 * 取得报表函数扩展
	 * @return 函数扩展
	 */
	public MetaExtReportFunction getExtReportFunction() {
		return this.metaExtReportFunction;
	}
	
	/**
	 * 设置附件处理
	 * @param metaExtAttachementProcess 函数扩展定义
	 */
	public void setExtAttachmentProcess(MetaExtAttachmentProcess metaExtAttachmentProcess) {
		this.metaExtAttachmentProcess = metaExtAttachmentProcess;
	}
	
	/**
	 * 取得附件处理
	 * @return 函数扩展定义
	 */
	public MetaExtAttachmentProcess getExtAttachmentProcess() {
		return metaExtAttachmentProcess;
	}
	
	/**
	 * 设置数据文档载入服务
	 * @param metaExtDocumentService 文档载入服务
	 */
	public void setExtDocumentService(MetaExtDocumentService metaExtDocumentService) {
		this.metaExtDocumentService = metaExtDocumentService;
	}
	
	/**
	 * 取得数据文档载入服务
	 * @return
	 */
	public MetaExtDocumentService getExtDocumentService() {
		return this.metaExtDocumentService;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaExtService.TAG_NAME.equals(tagName) ) {
			metaExtSvr = new MetaExtService();
			resultMetaObject = metaExtSvr;
		}else if ( MetaExtMidFunction.TAG_NAME.equals(tagName) ) {
			metaExtMidFunc = new MetaExtMidFunction();
			resultMetaObject = metaExtMidFunc;
		}else if ( MetaExtUIFunction.TAG_NAME.equals(tagName) ) {
			metaExtUIFunc = new MetaExtUIFunction();
			resultMetaObject = metaExtUIFunc;
		} else if ( MetaExtStartListener.TAG_NAME.equals(tagName) ) {
			startListener = new MetaExtStartListener();
			resultMetaObject = startListener;
		}else if ( MetaExtUpdateListener.TAG_NAME.equals(tagName) ) {
			updateListener = new MetaExtUpdateListener();
			resultMetaObject = updateListener;
		} else if ( MetaExtImportService.TAG_NAME.equals(tagName)) {
			metaExtImportService = new MetaExtImportService();
			resultMetaObject = metaExtImportService;
		} else if ( MetaExtExportService.TAG_NAME.equalsIgnoreCase(tagName) ) {
			metaExtExportService = new MetaExtExportService();
			resultMetaObject = metaExtExportService;
		} else if ( MetaExtPostExportService.TAG_NAME.equals(tagName)) {
			metaExtPostExportService = new MetaExtPostExportService();
			resultMetaObject = metaExtPostExportService;
		} else if ( MetaExtSysService.TAG_NAME.equals(tagName)) {
			metaExtSysSvr = new MetaExtSysService();
			resultMetaObject = metaExtSysSvr;
		} else if ( MetaExtReportFunction.TAG_NAME.equals(tagName) ) {
			metaExtReportFunction = new MetaExtReportFunction();
			resultMetaObject = this.metaExtReportFunction;
		} else if ( MetaExtDataProcess.TAG_NAME.equals(tagName) ) {
			metaExtDataProcess = new MetaExtDataProcess();
			resultMetaObject = this.metaExtDataProcess;
		} else if ( MetaExtAttachmentProcess.TAG_NAME.equals(tagName) ) {
			metaExtAttachmentProcess = new MetaExtAttachmentProcess();
			resultMetaObject = this.metaExtAttachmentProcess;
		} else if ( MetaExtDocumentService.TAG_NAME.equals(tagName) ) {
			metaExtDocumentService = new MetaExtDocumentService();
			resultMetaObject = this.metaExtDocumentService;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEnhance meta = new MetaEnhance();
		meta.metaExtSvr = metaExtSvr == null ? null : (MetaExtService) metaExtSvr.clone();
		meta.metaExtMidFunc = metaExtMidFunc == null ? null : (MetaExtMidFunction) metaExtMidFunc.clone();
		meta.metaExtUIFunc = metaExtUIFunc == null ? null : (MetaExtUIFunction) metaExtUIFunc.clone();
		meta.startListener = startListener == null ? null : (MetaExtStartListener)startListener.clone();
		meta.updateListener = updateListener == null ? null : (MetaExtUpdateListener)updateListener.clone();
		meta.metaExtImportService = metaExtImportService == null ? null : (MetaExtImportService)metaExtImportService.clone();
		meta.metaExtExportService = metaExtExportService == null ? null : (MetaExtExportService)metaExtExportService.clone();
		meta.metaExtPostExportService = metaExtPostExportService == null ? null : (MetaExtPostExportService)metaExtPostExportService.clone();
		meta.metaExtSysSvr = metaExtSysSvr == null ? null : (MetaExtSysService)metaExtSysSvr.clone();
		meta.setExtReportFunction(metaExtReportFunction == null ? null : (MetaExtReportFunction)metaExtReportFunction.clone());
		meta.metaExtDataProcess = metaExtDataProcess == null ? null : (MetaExtDataProcess)metaExtDataProcess.clone();
		meta.metaExtAttachmentProcess = metaExtAttachmentProcess == null ? null : (MetaExtAttachmentProcess)metaExtAttachmentProcess.clone();
		meta.metaExtDocumentService = metaExtDocumentService == null ? null : (MetaExtDocumentService) metaExtDocumentService.clone();
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEnhance();
	}

	@Override
	public MetaEnhance toMerge(MetaEnhance obj) {
		if (obj != null) {
			metaExtSvr.toMerge(obj.metaExtSvr); 
			metaExtMidFunc.toMerge(obj.metaExtMidFunc);
			metaExtUIFunc.toMerge(obj.metaExtUIFunc); 
			startListener.toMerge(obj.startListener);
			updateListener.toMerge(obj.updateListener);
			metaExtImportService.toMerge(obj.metaExtImportService);
			metaExtPostExportService.toMerge(obj.metaExtPostExportService);
			metaExtSysSvr.toMerge(obj.metaExtSysSvr);
			metaExtExportService.toMerge(obj.metaExtExportService);
			metaExtReportFunction.toMerge(obj.metaExtReportFunction);
			metaExtDataProcess.toMerge(obj.metaExtDataProcess);
			metaExtAttachmentProcess.toMerge(obj.metaExtAttachmentProcess);
			metaExtDocumentService.toMerge(obj.metaExtDocumentService);
		}
		return this;
	}

}