package com.bokesoft.yigo.meta.diff;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.util.DiffActionManager;

// GenericNoKeyCollection 表格列,单元格需要按差异编辑的顺序添加
public class MetaAddCollection extends GenericNoKeyCollection<MetaAdd> {
	
	private MetaIndexCollection indexCollection;

	public static final String TAG_NAME = "AddCollection";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if( indexCollection != null ) {
			list.add(indexCollection);
		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	public MetaIndexCollection getIndexCollection() {
		return indexCollection;
	}

	public void setIndexCollection(MetaIndexCollection indexCollection) {
		this.indexCollection = indexCollection;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject meta = null;
		if (tagName.equals(MetaIndexCollection.TAG_NAME)) {
			this.indexCollection = new MetaIndexCollection();
			meta = this.indexCollection;
		} else if(MetaAdd.TAG_NAME.equals(tagName)) {
			meta = new MetaAdd();
			meta.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaAdd) meta);
		} else {
			// 用于兼容之前版本的配置结构
			AbstractMetaObject tmpMeta = DiffActionManager.getInstance().createMetaElement(tagName, env);
			if (tmpMeta != null) {
				tmpMeta.traversalSingle(env, doc, node, flag, runType);
				//tmpMeta.preProcessMetaObject(env, doc, node, flag, runType);
				if (tmpMeta instanceof KeyPairMetaObject) {
					MetaAdd addMeta = new MetaAdd(((KeyPairMetaObject) tmpMeta).getKey());
					addMeta.setBase(tmpMeta);
					this.add(addMeta);
					return tmpMeta;
				}
			}
		}
		return meta;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaAddCollection();
	}

}
