package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaStatement;

/**
 * MetaRuleFilter定义根据规则使用的过滤条件，用于在数据源的表中动态确定过滤条件。
 * @author wangyh
 *
 */
public class MetaTableSource extends AbstractMetaObject {
	/** 标识 */
	private String key = "";
	/** 描述 */
	private String description = "";
	/** 数据关联表标识 */
	private String dbTableName = "";
	/** 来源类型 */
	private Integer sourceType = TableSourceType.DATAOBJECT;
	/** 查询语句 */
	private MetaStatement statement = null;
	/** 表达式 */
	private String formula = "";
	/** 实现类的名称 */
	private String impl = "";
	/** 使用规则 */
	private String rule = "";
	/** 过滤 */
	private MetaTableFilter filter = null;
	/** 参数集 */
	private MetaParameterCollection parameterCollection = null;
	/** 关联表标识 */
	private String linkTable = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { filter, parameterCollection , statement});
	}

	public static final String TAG_NAME = "TableSource";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTableFilter.TAG_NAME.equals(tagName) ) {
			this.filter = new MetaTableFilter();
			resultMetaObject = this.filter;
		} else if ( MetaParameterCollection.TAG_NAME.equals(tagName) ) {
			this.parameterCollection = new MetaParameterCollection();
			resultMetaObject = this.parameterCollection;
		} else if ( MetaStatement.TAG_NAME.equals(tagName) ) {
			this.statement = new MetaStatement();
			resultMetaObject = this.statement;
		}
		return resultMetaObject;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置数据库表名称
	 * @param dbTableName 数据库表名称
	 */
	public void setDBTableName(String dbTableName) {
		this.dbTableName = dbTableName;
	}
	
	/**
	 * 取得数据库表名称
	 * @return 数据库表名称
	 */
	public String getDBTableName() {
		return this.dbTableName;
	}
	
	/**
	 * 设置来源类型
	 * @param sourceType 来源类型
	 */
	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}
	
	/**
	 * 取得来源类型
	 * @return 来源类型
	 */
	public Integer getSourceType() {
		return this.sourceType;
	}
	
	/**
	 * 设置语句
	 * @param statement 语句定义
	 */
	public void setStatement(MetaStatement statement) {
		this.statement = statement;
	}
	
	/**
	 * 取得语句
	 * @return 语句定义
	 */
	public MetaStatement getStatement() {
		return this.statement;
	}
	
	/**
	 * 设置规则
	 * @param rule 规则
	 */
	public void setRule(String rule) {
		this.rule = rule;
	}
	
	/**
	 * 取得规则
	 * @return 规则
	 */
	public String getRule() {
		return this.rule;
	}
	
	/**
	 * 设置过滤
	 * @param filter 过滤
	 */
	public void setFilter(MetaTableFilter filter) {
		this.filter = filter;
	}
	
	/**
	 * 取得过滤
	 * @return 过滤
	 */
	public MetaTableFilter getFilter() {
		return this.filter;
	}
	
	/**
	 * 设置表达式
	 * @param formula 表达式
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}
	
	/**
	 * 取得表达式
	 * @return 表达式
	 */
	public String getFormula() {
		return this.formula;
	}
	
	/**
	 * 设置实现类
	 * @param impl 实现类
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}
	
	/**
	 * 取得实现类
	 * @return 实现类
	 */
	public String getImpl() {
		return this.impl;
	}
	
	/**
	 * 设置参数集
	 * @param parameterCollection 参数集
	 */
	public void setParameterCollection(MetaParameterCollection parameterCollection) {
		this.parameterCollection = parameterCollection;
	}
	
	/**
	 * 取得参数集
	 * @return 参数集
	 */
	public MetaParameterCollection getParameterCollection() {
		return this.parameterCollection;
	}
	
	/**
	 * 关联表标识
	 * @param linkTable 表标识
	 */
	public void setLinkTable(String linkTable) {
		this.linkTable = linkTable;
	}
	
	/**
	 * 取得关联表标识
	 * @return 表标识
	 */
	public String getLinkTable() {
		return this.linkTable;
	}
	
	/**
	 * 取得字符串查询语句
	 * 
	 * @return 字符串查询语句
	 */
	public String getStringStatement() {
		return this.statement != null ? this.statement.getContent() : null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTableSource newObject = (MetaTableSource)newInstance();
		newObject.setKey(key);
		newObject.setSourceType(sourceType);
		newObject.setStatement(statement == null ? null : (MetaStatement)statement.clone());
		newObject.setFormula(formula);
		newObject.setImpl(impl);
		newObject.setDBTableName(dbTableName);
		newObject.setLinkTable(linkTable);
		newObject.setRule(rule);
		newObject.setFilter(filter != null ? (MetaTableFilter)filter.clone() : null);
		newObject.setParameterCollection(parameterCollection != null ? (MetaParameterCollection)parameterCollection.clone() : null);
		newObject.setDescription(description);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTableSource();
	}

}
