package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaPostSaveProcess定义数据对象保存后的处理，由多个{@link MetaProcess}组成，系统按顺序依次执行这些处理。
 * @author 王元和
 * @see MetaProcess
 */
public class MetaPostSaveProcess extends GenericNoKeyCollection<MetaProcess> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "PostSaveProcess";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if ( MetaProcess.TAG_NAME.equals(tagName) ) {
			metaObject = new MetaProcess();
			metaObject.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaProcess)metaObject);
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPostSaveProcess();
	}

}
