package com.bokesoft.yigo.meta.dataobject;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaDataObjectList extends GenericKeyCollection<MetaDataObjectProfile> implements IElementMerge<MetaDataObjectList>{
	public MetaDataObjectList() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "DataObjectList";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if ( MetaDataObjectProfile.TAG_NAME.equals(tagName) ) {
			MetaDataObjectProfile metaDataObjectProfile = new MetaDataObjectProfile();
			metaDataObjectProfile.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaDataObjectProfile);
			child = metaDataObjectProfile;
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataObjectList();
	}

	@Override
	public MetaDataObjectList toMerge(MetaDataObjectList obj) {
		if (obj != null) {
			Iterator<MetaDataObjectProfile> iterator = obj.iterator();
			while (iterator.hasNext()) {
				MetaDataObjectProfile metaDataObjectProfile = (MetaDataObjectProfile) iterator.next();
				if (containsKey(metaDataObjectProfile.getKey())) {
					MetaDataObjectProfile tmpDataObjectProfile = get(metaDataObjectProfile.getKey());
					IMetaProject tmpProject = tmpDataObjectProfile.getProject();
					throw new MetaException(MetaException.REPEAT_DATAOBJECT_DEFINED,
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatDataObjectDefined), 
									metaDataObjectProfile.getProject().getKey(), "", metaDataObjectProfile.getKey(),
									tmpProject.getKey(), tmpDataObjectProfile.getFormKey()));
				}
				add(metaDataObjectProfile);
			}
		}
		return this;
	}
}
