package com.bokesoft.yigo.meta.dataobject;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaCheckRuleCollection定义数据对象的规则集合，由多个{@link MetaCheckRule}组成。系统按规则的顺序依次执行这些规则检查。
 * @author 王元和
 *
 */
public class MetaCheckRuleCollection extends GenericNoKeyCollection<MetaCheckRule> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "CheckRuleCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject metaObject = null;
		if ( MetaCheckRule.TAG_NAME.equals(tagName) ) {
			metaObject = new MetaCheckRule();
			metaObject.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaCheckRule)metaObject);
		}
		return metaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCheckRuleCollection();
	}

}
