package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;

public class MessageDataObjectCreator {
	public static final MetaDataObject getProducerMessageDataObject() throws MetaException {
		MetaDataObject producerMessageTableDao = new MetaDataObject();
		producerMessageTableDao.setAutoGen(true);
		producerMessageTableDao.setKey("ProducerMessage");
		producerMessageTableDao.setPrimaryType(DataObjectPrimaryType.ENTITY);
		MetaTableCollection tableCollection = new MetaTableCollection();
		producerMessageTableDao.setCaption("");
		producerMessageTableDao.setTableCollection(tableCollection);
		
		MetaTable producerMessage = createTable(producerMessageTableDao, "ProducerMessage");
		addColumn(producerMessage, "ID", DataType.STRING, 255).setPrimaryKey(true);;
		addColumn(producerMessage, "Tag", DataType.STRING, 255);
		addColumn(producerMessage, "CreateTime", DataType.DATETIME, 0);
		addColumn(producerMessage, "Description", DataType.STRING, 255);
		addColumn(producerMessage, "State", DataType.INT, 0 );
		addColumn(producerMessage, "Message", DataType.BINARY, 0);
		addIndex(producerMessage, "Tag", "Tag");
		
		return producerMessageTableDao;
	}
	
	public static final MetaDataObject getConsumerMessageDataObject() throws MetaException {
		MetaDataObject consumerMessageTableDao = new MetaDataObject();
		consumerMessageTableDao.setAutoGen(true);
		consumerMessageTableDao.setKey("ConsumerMessage");
		consumerMessageTableDao.setPrimaryType(DataObjectPrimaryType.ENTITY);
		MetaTableCollection tableCollection = new MetaTableCollection();
		consumerMessageTableDao.setCaption("");
		consumerMessageTableDao.setTableCollection(tableCollection);
		
		MetaTable consumerMessage = createTable(consumerMessageTableDao, "ConsumerMessage");
		addColumn(consumerMessage, "ID", DataType.STRING, 255).setPrimaryKey(true);
		addColumn(consumerMessage, "Tag", DataType.STRING, 255);
		addColumn(consumerMessage, "CreateTime", DataType.DATETIME, 0);
		addColumn(consumerMessage, "FinishTime", DataType.DATETIME, 0);
		addColumn(consumerMessage, "Description", DataType.STRING, 255);
		
		return consumerMessageTableDao;
	}
	
	private static MetaTable createTable(MetaDataObject dataObject, String key) {
		MetaTable table = new MetaTable();
		table.setKey(key);
		table.setCaption("");
		table.setDBTableName("");
		table.setFilter(null);
		table.setSourceType(TableSourceType.DATAOBJECT);
		table.setTableMode(TableMode.DETAIL);
		return dataObject.getTableCollection().add(table);
	}

	private static MetaColumn addColumn(MetaTable table, String key, int dataType, int length) {
		MetaColumn column = new MetaColumn();
		column.setKey(key);
		column.setCaption("");
		column.setDefaultValue("");
		column.setDescription("");
		column.setDBColumnName("");
		column.setDataType(dataType);
		column.setLength(length);
		column.setAutoGen(true);
		table.add(column);
		return column;
	}

	private static MetaIndex addIndex(MetaTable table, String key, String columns) {
		MetaIndexCollection indexCollection = table.getIndexCollection();
		if (indexCollection == null) {
			indexCollection = new MetaIndexCollection();
			table.setIndexCollection(indexCollection);
		}

		MetaIndex index = new MetaIndex();
		indexCollection.add(index);
		index.setColumns(columns);
		index.setKey(table.getIndexPrefix4Create() + key);
		return index;
	}
}
