package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.*;

/**
 * MetaDMTargetTableCollection定义迁移的目标表集合，但只能有一个目标表。具体定义内容包括：
 * <p>目标数据对象元数据标识，定义迁移目标的数据对象元数据，数据对象需要支持持久化。
 * </p>
 * <p>目标表集合，只能有一张表，且必须是支持持就化的表。目标表的定义详见{@link MetaDMTargetTable}。
 * </p>
 * @author 王元和
 * @since YES 1.0
 * @see MetaDMTargetTable
 */
public class MetaDMTargetTableCollection extends GenericKeyCollection<MetaDMTargetTable> {
	/** 水平位置 */
	private Integer x = -1;
	/** 垂直位置 */
	private Integer y = -1;
	/** 宽度 */
	private Integer width = -1;
	/** 高度 */
	private Integer height = -1;
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "TargetTableCollection";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置水平位置
	 * @param x 水平位置
	 */
	public void setX(Integer x) {
		this.x = x;
	}
	
	/**
	 * 取得水平位置
	 * @return 水平位置
	 */
	public Integer getX() {
		return this.x;
	}
	
	/**
	 * 设置垂直位置
	 * @param y 垂直位置
	 */
	public void setY(Integer y) {
		this.y = y;
	}
	
	/**
	 * 取得垂直位置
	 * @return 垂直位置
	 */
	public Integer getY() {
		return this.y;
	}
	
	/**
	 * 设置宽度
	 * @param width 宽度
	 */
	public void setWidth(Integer width) {
		this.width = width;
	}
	
	/**
	 * 取得宽度
	 * @return 宽度
	 */
	public Integer getWidth() {
		return this.width;
	}
	
	/**
	 * 设置高度
	 * @param height 高度
	 */
	public void setHeight(Integer height) {
		this.height = height;
	}
	
	/**
	 * 取得高度
	 * @return 高度
	 */
	public Integer getHeight() {
		return this.height;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaDMTargetTable.TAG_NAME.equals(tagName) ) {
			MetaDMTargetTable metaDMTargetTable = new MetaDMTargetTable();
			metaDMTargetTable.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaDMTargetTable);
			resultMetaObject = metaDMTargetTable;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDMTargetTableCollection();
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaDMTargetTableCollection newTargetTableCollection = (MetaDMTargetTableCollection) super.clone();
		newTargetTableCollection.setX(x);
		newTargetTableCollection.setY(y);
		newTargetTableCollection.setWidth(width);
		newTargetTableCollection.setHeight(height);
		return newTargetTableCollection;
	}
}
