package com.bokesoft.yigo.meta.commondef.resource;

import java.util.LinkedList;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaIconFontSourceCollection extends GenericKeyCollection<MetaIconFontSource> {

    public static final String TAG_NAME = "IconFontSourceCollection";

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv arg0, Object arg1, Object arg2, String arg3, Object arg4,
            int arg5) throws MetaException {
        if (arg3.equals(MetaIconFontSource.TAG_NAME)) {
            MetaIconFontSource iconScene = new MetaIconFontSource();
            iconScene.preProcessMetaObject(arg0, arg1, arg2, arg4, arg5);
            this.add(iconScene);
            return iconScene;
        }
        return null;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> arg0) {
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaIconFontSourceCollection();
    }

    public void addCollection(MetaIconFontSourceCollection collection) {
        if (collection == null) {
            return;
        }
        for (int i = 0; i < collection.size(); i++) {
            MetaIconFontSource fontSource = collection.get(i);
            this.add(fontSource);
        }
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        for (int i = 0; i < this.size(); i++) {
            MetaIconFontSource fontSource = this.get(i);
            fontSource.doPostProcess(flag, callback);
        }
    }
}
