package com.bokesoft.yigo.meta.commondef.extend;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;

import java.util.Iterator;
import java.util.LinkedList;

public class MetaCommonDefCollection extends GenericKeyCollection<MetaCommonDef> implements IElementMerge<MetaCommonDefCollection> {
	public static final String TAG_NAME = "CommonDefVestCollection";
	private String solutionKey;

	public String getSolutionKey() {
		return solutionKey;
	}

	public void setSolutionKey(String solutionKey) {
		this.solutionKey = solutionKey;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {

	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaCommonDef.TAG_NAME.equals(tagName)) {
			MetaCommonDef metaMacro = new MetaCommonDef();
			metaMacro.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(metaMacro);
			resultMetaObject = metaMacro;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCommonDefCollection();
	}

	@Override
	public MetaCommonDefCollection toMerge(MetaCommonDefCollection obj) {
		if (obj != null) {
			for (MetaCommonDef metaCommonDef : obj) {
				if (this.containsKey(metaCommonDef.getKey())) {
					this.get(metaCommonDef.getKey()).toMerge(metaCommonDef);
				} else {
					this.add(metaCommonDef);
				}
			}
		}
		return this;
	}


}
