package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.CondSign;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaCondition extends AbstractMetaObject {

	/** 条件的标识 */
	private String tag = "";
	/** 条件符号 */
	private Integer sign = CondSign.NONE;
	/** 条件组标识 */
	private String group = "";
	/** 条件组头标志 */
	private Boolean groupHead = false;
	/** 条件组尾标志 */
	private Boolean groupTail = false;
	/** 条件符号的右值 */
	private String opValue = "";
	/** 定制条件的实现类的名称 */
	private String impl = "";
	/** 条件关联的数据表标识 */
	private String tableKey = "";
	/** 条件关联的数据表的明细表标识 */
	private String subTableKey = "";
	/** 条件关联的数据列标识 */
	private String columnKey = "";
	/** 查询的目标 */
	private String target = "";
	/** 查询目标集合 */
	private MetaConditionTargetCollection targets = null;
	/** 定制查询集合 */
	private MetaCustomConditionCollection customs = null;
	/** 空值时是否加上查询字段的查询范围（用于字典，下拉框）*/
	private Boolean limitToSource = false;
	/** 查询条件重置标志  */
	private Boolean needReset = true;
	/** 是否载入历史纪录 */
	//仅对查询界面起作用
	private Boolean loadHistoryInput = false;
	/** 是否仅在GetConditionFilter中使用 */
	private Boolean onlyFilter = false;
	/** 是否高级查询功能,适用于查询界面 */
	private Boolean useAdvancedQuery = false;
	public MetaCondition() {
		super();
		this.targets = new MetaConditionTargetCollection();
		this.customs = new MetaCustomConditionCollection();
	}
	public Boolean isUseAdvancedQuery() {
		return useAdvancedQuery;
	}

	public void setUseAdvancedQuery(Boolean useAdvancedQuery) {
		this.useAdvancedQuery = useAdvancedQuery;
	}
	public void setSign(Integer sign) {
		this.sign = sign;
	}

	public Integer getSign() {
		return this.sign;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public String getGroup() {
		return this.group;
	}

	public void setGroupHead(Boolean groupHead) {
		this.groupHead = groupHead;
	}

	public Boolean isGroupHead() {
		return this.groupHead;
	}

	public void setGroupTail(Boolean groupTail) {
		this.groupTail = groupTail;
	}

	public Boolean isGroupTail() {
		return this.groupTail;
	}

	public void setOpValue(String opValue) {
		this.opValue = opValue;
	}

	public String getOpValue() {
		return this.opValue;
	}

	/**
	 * 设置定制条件实现类
	 * 
	 * @param impl
	 *            定制条件实现类
	 */
	public void setImpl(String impl) {
		this.impl = impl;
	}

	/**
	 * 取得定制条件实现类
	 * 
	 * @return 定制条件实现类
	 */
	public String getImpl() {
		return this.impl;
	}

	public void setTableKey(String tableKey) {
		this.tableKey = tableKey;
	}

	public String getTableKey() {
		return this.tableKey;
	}
	
	public String getSubTableKey() {
		return subTableKey;
	}

	public void setSubTableKey(String subTableKey) {
		this.subTableKey = subTableKey;
	}

	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}

	public String getColumnKey() {
		return this.columnKey;
	}

	/**
	 * 设置查询的目标字段
	 * 
	 * @param target
	 *            　目标字段标识
	 */
	public void setTarget(String target) {
		this.target = target;
	}

	/**
	 * 取得查询的目标字段
	 * 
	 * @return 目标字段标识
	 */
	public String getTarget() {
		return this.target;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}
	
	/**
	 * 是否允许空值时，加上查询字段的查询范围
	 * @return 查询时是否加上查询范围标志
	 */
	public Boolean isLimitToSource(){
		return this.limitToSource;
	}
	
	/**
	 * 设置是否允许空值时，加上查询字段的查询范围
	 * @param b 布尔值
	 */
	public void setLimitToSource(Boolean b){
		this.limitToSource = b;
	}
	
	/**
	 *  是否允许重置查询条件
	 *  @return 查询条件是否需要重置的标志
	 */
	public Boolean needReset(){
		return this.needReset;
	}
	
	/**
	 * 设置是否重置查询条件 
	 * @param b 布尔值
	 */
	public void setNeedReset(Boolean b){
		this.needReset = b;
	}

	/**
	 * 是否载入历史记录
	 * @return 标志
	 */
	public Boolean isLoadHistoryInput(){
		return this.loadHistoryInput;
	}
	
	/**
	 * 设置是否允许空值时，加上查询字段的查询范围
	 * @param b 布尔值
	 */
	public void setLoadHistoryInput(Boolean b){
		this.loadHistoryInput = b;
	}
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		this.addAll2(list, this.targets, this.customs);
	}

	public static final String TAG_NAME = "Condition";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		resultMetaObject = this.targets.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if ( resultMetaObject == null ) {
			resultMetaObject = this.customs.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCondition newObject = (MetaCondition)newInstance();
		newObject.setSign(sign);
		newObject.setGroup(group);
		newObject.setGroupHead(groupHead);
		newObject.setGroupTail(groupTail);
		newObject.setOpValue(opValue);
		newObject.setImpl(impl);
		newObject.setTableKey(tableKey);
		newObject.setSubTableKey(subTableKey);
		newObject.setColumnKey(columnKey);
		newObject.setTarget(target);
		newObject.setTargets(targets == null ? null : (MetaConditionTargetCollection)targets.clone());
		newObject.setCustoms(customs == null ? null : (MetaCustomConditionCollection)customs.clone());
		newObject.setLimitToSource(limitToSource);
		newObject.setNeedReset(needReset);
		newObject.setOnlyFilter(onlyFilter);
		newObject.setLoadHistoryInput(loadHistoryInput);
		newObject.setUseAdvancedQuery(useAdvancedQuery);
		newObject.setTag(tag);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCondition();
	}

	/**
	 * 设置查询目标集合
	 * @param targets 查询目标集合
	 */
	public void setTargets(MetaConditionTargetCollection targets) {
		this.targets = targets;
	}
	
	/**
	 * 取得查询目标集合
	 * @return 查询目标集合
	 */
	public MetaConditionTargetCollection getTargets() {
		return this.targets;
	}
	
	/**
	 * 设置定制查询集合
	 * @param customs 定制查询集合
	 */
	public void setCustoms(MetaCustomConditionCollection customs) {
		this.customs = customs;
	}
	
	/**
	 * 取得定制查询集合
	 * @return 定制查询集合
	 */
	public MetaCustomConditionCollection getCustoms() {
		return this.customs;
	}
	
	/**
	 * 是否仅在getConditionFilter公式中使用
	 * @return
	 */
	public Boolean isOnlyFilter() {
		return onlyFilter;
	}

	/**
	 * 设置是否仅在getConditionFilter公式中使用
	 * @param onlyFilter
	 */
	public void setOnlyFilter(Boolean onlyFilter) {
		this.onlyFilter = onlyFilter;
	}
}
