package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ScriptRunType;
import com.bokesoft.yigo.common.def.ScriptType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;


/**
 * MetaBaseScript定义所有在元数据描述文件中的脚本片断，包括脚本的类型和内容，在系统中，脚本的内容分为三种类型，分别是:
 * <ul>
 * <li>表达式，系统解析的文本字符串，规则由平台的表达式规则描述
 * <li>JavaScript脚本
 * <li>Java代码
 * </ul>
 * @author 王元和
 * @since YES 1.0
 */
public class MetaBaseScript extends KeyPairMetaObject implements IPropertyMerger<MetaBaseScript> {
	/** 脚本的标签 */
	private String tagName = null;
	/** 
	 * 脚本的类型，其取值的范围在{@link com.bokesoft.yigo.common.def.ScriptType}中定义。
	 * @see com.bokesoft.yigo.common.def.ScriptType
	 *  */
	private Integer type = ScriptType.Formula;
	/** 脚本的内容 */
	protected String content = "";
	/** 脚本的运行位置类型 */
	private Integer runType = ScriptRunType.Undefined;
	
	public MetaBaseScript(String tagName) {
		super();
		this.tagName = tagName;
	}
	
	/**
	 * 设置脚本的标记名称
	 * @param tagName 标记名称
	 */
	public void setTagName(String tagName) {
		this.tagName = tagName;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return this.tagName;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		return null;
	}

	/**
	 * 设置脚本类型
	 * @param type 类型，取值为ScriptType中的取值范围
	 * @see com.bokesoft.yigo.common.def.ScriptType
	 */
	public void setType(Integer type) {
		this.type = type;
	}
	
	/**
	 * 取得脚本类型
	 * @return 脚本类型
	 */
	public Integer getType() {
		return this.type;
	}
	
	/**
	 * 设置脚本的运行位置类型
	 * @param runType 脚本的运行位置类型，取值为ScriptRunType的取值范围
	 * @see com.bokesoft.yigo.common.def.ScriptRunType
	 */
	public void setRunType(Integer runType) {
		this.runType = runType;
	}
	
	/**
	 * 取得脚本的运行位置类型
	 * @return 脚本运行位置类型
	 * @see com.bokesoft.yigo.common.def.ScriptRunType
	 */
	public Integer getRunType() {
		return this.runType;
	}
	
	/**
	 * 设置脚本内容
	 * @param content 脚本内容
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
	/**
	 * 取得脚本内容
	 * @return 脚本内容
	 */
	public String getContent() {
		return this.content;
	}
	
	/**
	 * 判断脚本是否为空
	 * @return 如果脚本为空，返回true，否则返回false
	 */
	public boolean isEmpty() {
		return content == null || content.trim().isEmpty();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaBaseScript newObject = (MetaBaseScript)newInstance();
		newObject.setKey(key);
		newObject.setType(type);
		newObject.setRunType(runType);
		newObject.setContent(content);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBaseScript(tagName);
	}
	
	/** 标识，多数情况下并不使用这个属性 */
	private String key = "";
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((content == null) ? 0 : content.hashCode());
		result = prime * result + type;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		MetaBaseScript other = (MetaBaseScript) obj;
		if (type != other.type)
			return false;
		if (content == null) {
			if (other.content != null)
				return false;
		} else if (!content.equals(other.content))
			return false;
		return true;
	}
	
	@Override
	public boolean needPreLoad() {
		return false;
	}
	
	@Override
	public void merge(MetaBaseScript script) {
		if( this.type == -1 ) {
			this.type = script.getType();
		}
		if( this.content == null ) {
			this.content = script.getContent();
		}
		if( this.runType == -1 ) {
			this.runType = script.getRunType();
		}
	}
}
