package com.bokesoft.yigo.meta.charging;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

/**
 * MetaChargingPara定义计费参数，这么参数用于在条件和表达式中优化计费的计算过程，
 * 整个计费组中的每个参数针对计费对象中的每一个对象只计算一次。
 * @author wangyh
 *
 */
public class MetaChargingPara extends MetaBaseScript {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	
	public MetaChargingPara() {
		super(TAG_NAME);
	}

	public static final String TAG_NAME = "ChargingPara";
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaChargingPara();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaChargingPara newObject = (MetaChargingPara)super.clone();
		newObject.setKey(key);
		newObject.setCaption(caption);
		
		return newObject;
	}
}
