package com.bokesoft.yigo.meta.bpm.total;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;

public class MetaProcessMap extends AbstractMetaObject {

	public final static String TAG_NAME = "ProcessMap";

	/** 绑定的类型，有两种：Form和DataObject，默认为Form */
	private Integer type = ProcessMapType.Form;

	/** KEY */
	private String key = "";

	/** 启动操作中文名称 */
	private String startCaption = "";

	/** 流程的KEY是否为动态绑定 */
	private Boolean dynamicBinding = false;

	/** 流程的KEY公式 */
	private String processKeyFormula = "";

	/** 流程的KEY */
	private String processKey = "";

	/** 启动操作 */
	private String startAction = "";
	
	/** 发起人权限*/
	private MetaPerm perm = new MetaPerm();

	/** 添加日期 */
	private String initDate = DateUtil.getDateFormatText(null, "yyyy.MM.dd HH:mm:ss z");

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if(perm != null){
			list.add(perm);
		}
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaPerm.TAG_NAME)) {
			perm = new MetaPerm();
			child = perm;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProcessMap newMap = new MetaProcessMap();
		newMap.setType(type);
		newMap.setKey(key);
		newMap.setStartCaption(startCaption);
		newMap.setDynamicBinding(dynamicBinding);
		newMap.setProcessKeyFormula(processKeyFormula);
		newMap.setProcessKey(processKey);
		newMap.setStartAction(startAction);
		newMap.setPerm(perm == null ? null : (MetaPerm)perm.clone());
		return newMap;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProcessMap();
	}

	public String getStartCaption() {
		return startCaption;
	}

	public void setStartCaption(String startCaption) {
		this.startCaption = startCaption;
	}

	public String getProcessKey() {
		return processKey;
	}

	public void setProcessKey(String processKey) {
		this.processKey = processKey;
	}

	public String getInitDate() {
		return initDate;
	}

	public void setInitDate(String initDate) {
		this.initDate = initDate;
	}

	public String getStartAction() {
		return startAction;
	}

	public void setStartAction(String startAction) {
		this.startAction = startAction;
	}

	public Boolean isDynamicBinding() {
		return dynamicBinding;
	}

	public void setDynamicBinding(Boolean dynamicBinding) {
		this.dynamicBinding = dynamicBinding;
	}

	public String getProcessKeyFormula() {
		return processKeyFormula;
	}

	public void setProcessKeyFormula(String processKeyFormula) {
		this.processKeyFormula = processKeyFormula;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	
	public MetaPerm getPerm() {
		return perm;
	}
	
	public void setPerm(MetaPerm perm) {
		this.perm = perm;
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("tag-name", getTagName());
		obj.put("type", type);
		obj.put("key", key);
		obj.put("startCaption", startCaption);
		obj.put("dynamicBinding", dynamicBinding);
		obj.put("processKeyFormula", processKeyFormula);
		obj.put("processKey", processKey);
		obj.put("startAction", startAction);
		obj.put("initDate", initDate);
		if(perm != null){
			obj.put("perm", perm.toJSON());
		}
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		type = json.optInt("type");
		key = json.optString("key");
		startCaption = json.optString("startCaption");
		dynamicBinding = json.optBoolean("dynamicBinding");
		processKeyFormula = json.optString("processKeyFormula");
		processKey = json.optString("processKey");
		startAction = json.optString("startAction");
		initDate = json.optString("initDate");
		if(json.has("perm")){
			perm = new MetaPerm();
			perm.fromJSON(json.getJSONObject("perm"));
		}
	}

}
