package com.bokesoft.yigo.meta.bpm.total;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map.Entry;
import java.util.Set;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;

/**
 * 业务流程的全局定义，包含流程的部署信息、单据与流程的关联信息
 * 
 * @author 刘翔翔
 *
 */
public class MetaBPM extends AbstractMetaObject implements IElementMerge<MetaBPM> {

	/** 源文件对应的标签名称 */
	public final static String TAG_NAME = "BPM";

	/** 业务流程迁移表的KEY */
	public final static String DATA_MIGRATION_KEY = "BPM_Migration";

	/** 初始化日期 */
	private String initDate = DateUtil.getDateFormatText(null, "yyyy.MM.dd HH:mm:ss z");

	/** 流程的部署信息 */
	private MetaProcessDeployInfoCollection deployInfoCollection = new MetaProcessDeployInfoCollection();

	/** 流程与单据的关联信息 */
	private MetaProcessMapCollection mapCollection = new MetaProcessMapCollection();

	/** 流程的快照Map */
	private HashMap<String, ProcessDefinitionProfile> profileMap = new HashMap<String, ProcessDefinitionProfile>();

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(deployInfoCollection);
		list.add(mapCollection);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject amo = null;

		if (tagName.equalsIgnoreCase(MetaProcessDeployInfoCollection.TAG_NAME)) {
			deployInfoCollection = new MetaProcessDeployInfoCollection();
			amo = deployInfoCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaProcessMapCollection.TAG_NAME)) {
			mapCollection = new MetaProcessMapCollection();
			amo = mapCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return amo;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPM();
	}

	public String getInitDate() {
		return initDate;
	}

	public void setInitDate(String initDate) {
		this.initDate = initDate;
	}

	public HashMap<String, ProcessDefinitionProfile> getProfileMap() {
		return profileMap;
	}

	public void setProfileMap(HashMap<String, ProcessDefinitionProfile> profileMap) {
		this.profileMap = profileMap;
	}

	public MetaProcessDeployInfoCollection getMetaBPMDeployInfoCollection() {
		return deployInfoCollection;
	}
	
	public void setMetaBPMDeployInfoCollection(MetaProcessDeployInfoCollection deployInfoCollection) {
		this.deployInfoCollection = deployInfoCollection;
	}

	public MetaProcessMapCollection getMetaProcessMapCollection() {
		return mapCollection;
	}
	
	public void setMetaMapCollection(MetaProcessMapCollection mapCollection) {
		this.mapCollection = mapCollection;
	}

	@Override
	public MetaBPM toMerge(MetaBPM obj) {
		if (obj != null) {
			//deployInfo
			Iterator<MetaProcessDeployInfo> iterator = obj.getMetaBPMDeployInfoCollection().iterator();
			while (iterator.hasNext()) {
				MetaProcessDeployInfo metaProcessDeployInfo = (MetaProcessDeployInfo) iterator.next();
				if (deployInfoCollection.containsKey(metaProcessDeployInfo.getKey())) {
					throw new MetaException(MetaException.REPEAT_PROCESS_DEPLOY,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatProcessDeploy),
									metaProcessDeployInfo.getKey()));
				}
				deployInfoCollection.add(metaProcessDeployInfo);
			}
			
			//processMap
			Iterator<MetaProcessMap> iterator2 = obj.getMetaProcessMapCollection().iterator();
			while (iterator2.hasNext()) {
				MetaProcessMap metaProcessMap = (MetaProcessMap) iterator2.next();
				mapCollection.add(metaProcessMap);
			}
			
			//processProfile
			Set<Entry<String, ProcessDefinitionProfile>> entrySet = obj.getProfileMap().entrySet();
			for (Entry<String, ProcessDefinitionProfile> entry : entrySet) {
				if (profileMap.containsKey(entry.getKey())) {
					String key = entry.getKey();
					ProcessDefinitionProfile value = entry.getValue();
					throw new MetaException(MetaException.REPEAT_PROCESS_DEFINED,
							SimpleStringFormat.format(
									StringTable.getString(null, "", StringTable.RepeatProcessDefined),
									key));
				}
				profileMap.put(entry.getKey(), entry.getValue());
			}
			
		}
		return this;
	}
}
