package com.bokesoft.yigo.meta.bpm.process.transition;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;

public abstract class MetaTransition extends AbstractBPMElement {

	private MetaTransitionGraphic graphic = new MetaTransitionGraphic();

	private String targetNodeKey = "";

	/** 预处理时才会设置此对象，方便运行时使用 */
	private MetaNode targetNode = null;

	/**
	 * @return the targetNodeKey
	 */
	public String getTargetNodeKey() {
		return targetNodeKey;
	}

	/**
	 * @param targetNodeKey
	 *            the targetNodeKey to set
	 */
	public void setTargetNodeKey(String targetNodeKey) {
		this.targetNodeKey = targetNodeKey;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { graphic });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaTransitionGraphic.TAG_NAME)) {
			graphic = new MetaTransitionGraphic();
			child = graphic;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	public MetaTransitionGraphic getGraphic() {
		return graphic;
	}

	public void setGraphic(MetaTransitionGraphic graphic) {
		this.graphic = graphic;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("target-node-key", targetNodeKey);
		obj.put("caption", getCaption());
		if (graphic != null) {
			obj.put("graphic", graphic.toJSON());
		}

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		setCaption(json.optString("caption"));
		this.targetNodeKey = json.optString("target-node-key");
		if (json.has("graphic")) {
			this.graphic = new MetaTransitionGraphic();
			this.graphic.fromJSON(json.getJSONObject("graphic"));
		}
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTransitionGraphic();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTransition newTransition = (MetaTransition) super.clone();
		newTransition.setTargetNodeKey(targetNodeKey);
		newTransition.setGraphic(graphic == null ? null : (MetaTransitionGraphic) graphic.clone());

		return newTransition;
	}

	public MetaNode getTargetNode() {
		return targetNode;
	}

	public void setTargetNode(MetaNode targetNode) {
		this.targetNode = targetNode;
	}
}
