package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;

/**
 * 状态节点
 * 
 * @author 刘翔翔
 *
 */
public class MetaState extends MetaNode {

	public final static String TAG_NAME = "State";

	/** 状态标识 */
	private String status = "";

	/** 工作项创建事件 */
	private String createTrigger = "";

	/** 工作项完成事件 */
	private String finishTrigger = "";
	
	/** 绑定字段标识*/
	private String fieldKey = "";
	
	private String fieldValue = "";

	/** 参与者的集合 */
	private MetaParticipatorCollection participatorCollection = new MetaParticipatorCollection();

	/** 权限设置 */
	private MetaPerm perm = new MetaPerm();
	
	/** 是否启用状态任务 (由流程结构算出来的，此属性不做持久化)*/
	private boolean useStateTask = false;
	
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(participatorCollection);
		list.add(perm);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.STATE;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaState newState = (MetaState) super.clone();
		newState.setStatus(status);
		newState.setCreateTrigger(createTrigger);
		newState.setFinishTrigger(finishTrigger);
		newState.setFieldKey(fieldKey);
		newState.setFieldValue(fieldValue);
		newState.setParticipatorCollection(participatorCollection == null ? null : (MetaParticipatorCollection) participatorCollection.clone());
		newState.setPerm(perm == null ? null : (MetaPerm) perm.clone());
		return newState;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaState();
	}

	public String getStatus() {
		return this.status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("status", status);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.status = json.optString("status");
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (child != null)
			return child;
		if (tagName.equalsIgnoreCase(MetaParticipatorCollection.TAG_NAME)) {
			participatorCollection = new MetaParticipatorCollection();
			child = participatorCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaPerm.TAG_NAME)) {
			perm = new MetaPerm();
			child = perm;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	public String getCreateTrigger() {
		return createTrigger;
	}

	public void setCreateTrigger(String createTrigger) {
		this.createTrigger = createTrigger;
	}

	public String getFinishTrigger() {
		return finishTrigger;
	}

	public void setFinishTrigger(String finishTrigger) {
		this.finishTrigger = finishTrigger;
	}

	public MetaParticipatorCollection getParticipatorCollection() {
		return participatorCollection;
	}

	public void setParticipatorCollection(MetaParticipatorCollection participatorCollection) {
		this.participatorCollection = participatorCollection;
	}

	public MetaPerm getPerm() {
		return perm;
	}

	public void setPerm(MetaPerm perm) {
		this.perm = perm;
	}

	public boolean isUseStateTask() {
		return useStateTask;
	}

	public void setUseStateTask(boolean useStateTask) {
		this.useStateTask = useStateTask;
	}
	
	public void setFieldKey(String fieldKey) {
		this.fieldKey = fieldKey;
	}
	
	public String getFieldKey() {
		return fieldKey;
	}
	
	public void setFieldValue(String fieldValue) {
		this.fieldValue = fieldValue;
	}
	
	public String getFieldValue() {
		return fieldValue;
	}
}