package com.bokesoft.yigo.meta.bpm.process.node;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaJoin extends MetaNode {

	public final static String TAG_NAME = "Join";

	private Integer joinCount = 0;
	
	private MetaFork fork;
	/** 对应的分支节点的ID*/
	private Integer mateForkID = -1;
	
	public MetaFork getFork() {
		return fork;
	}

	public void setFork(MetaFork fork) {
		this.fork = fork;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.JOIN;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaJoin newObj = (MetaJoin) super.clone();
		newObj.setFork(fork == null ? null : (MetaFork)fork.clone());
		newObj.setJoinCount(joinCount);
		newObj.setMateForkID(mateForkID);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaJoin();
	}

	public Integer getJoinCount() {
		return joinCount;
	}

	public void setJoinCount(Integer joinCount) {
		this.joinCount = joinCount;
	}

	public Integer getMateForkID() {
		return mateForkID;
	}

	public void setMateForkID(Integer mateForkID) {
		this.mateForkID = mateForkID;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("join-count", joinCount);
		obj.put("mateForkID", mateForkID);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.joinCount = json.optInt("join-count");
		this.mateForkID = json.optInt("mateForkID");
	}

}
