package com.bokesoft.yigo.meta.bpm.process.node;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.process.attribute.type.ConditionType;

public class MetaCountersign extends MetaAudit {

	public final static String TAG_NAME = "Countersign";

	/** 通过类型 */
	private Integer passType = ConditionType.NONE;

	/** 通过条件 */
	private String passCondition = "";

	/** 成立条件类型 */
	private Integer validType = ConditionType.NONE;

	/** 成立条件 */
	private String validCondition = "";

	/** 完成条件 类型 */
	private Integer finishType = ConditionType.NONE;

	/** 会签完成条件 */
	private String finishCondition = "";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.COUNTERSIGN;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCountersign();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCountersign newCountersign = (MetaCountersign) super.clone();
		newCountersign.setPassType(passType);
		newCountersign.setPassCondition(passCondition);
		newCountersign.setValidType(validType);
		newCountersign.setValidCondition(validCondition);
		newCountersign.setFinishType(finishType);
		newCountersign.setFinishCondition(finishCondition);
		return newCountersign;
	}

	public Integer getPassType() {
		return passType;
	}

	public void setPassType(Integer passType) {
		this.passType = passType;
	}

	public String getPassCondition() {
		return passCondition;
	}

	public void setPassCondition(String passCondition) {
		this.passCondition = passCondition;
	}

	public Integer getValidType() {
		return validType;
	}

	public void setValidType(Integer validType) {
		this.validType = validType;
	}

	public String getValidCondition() {
		return validCondition;
	}

	public void setValidCondition(String validCondition) {
		this.validCondition = validCondition;
	}

	public String getFinishCondition() {
		return finishCondition;
	}

	public void setFinishCondition(String finishCondition) {
		this.finishCondition = finishCondition;
	}

	public Integer getFinishType() {
		return finishType;
	}

	public void setFinishType(Integer finishType) {
		this.finishType = finishType;
	}
}