package com.bokesoft.yigo.meta.bpm.process.data;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataInput;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataOutput;

public class MetaDataSpecification extends AbstractMetaObject {
	public static final String TAG_NAME = "DataSpecification";
	
	private MetaDataInput dataInput = null;
	private MetaDataOutput dataOutput = null;
	
	public MetaDataInput getDataInput() {
		return dataInput;
	}

	public void setDataInput(MetaDataInput dataInput) {
		this.dataInput = dataInput;
	}

	public MetaDataOutput getDataOutput() {
		return dataOutput;
	}

	public void setDataOutput(MetaDataOutput dataOutput) {
		this.dataOutput = dataOutput;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {	
		addAll(list, new Object[] {dataInput,dataOutput});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaDataOutput.TAG_NAME.equals(tagName)) {
			dataOutput = new MetaDataOutput();
			dataOutput.preProcessMetaObject(env, doc, node, flag, runType);
			child = dataOutput;
		}else if (MetaDataInput.TAG_NAME.equals(tagName)) {
			dataInput = new MetaDataInput();
			dataInput.preProcessMetaObject(env, doc, node, flag, runType);
			child = dataInput;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataSpecification obj = new MetaDataSpecification();
		obj.dataInput = dataInput == null ? null : (MetaDataInput)dataInput.clone();
		obj.dataOutput = dataOutput == null ? null : (MetaDataOutput) dataOutput.clone();
		return obj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataSpecification();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject object = new JSONObject();
		if (dataInput != null) {
			object.put("dataInput", dataInput.toJSON());
		}
		
		if (dataOutput != null) {
			object.put("dataOutput", dataOutput.toJSON());
		}
		
		return object;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if (json.has("dataInput")) {
			dataInput = new MetaDataInput();
			dataInput.fromJSON(json.getJSONObject("dataInput"));
		}
		
		if (json.has("dataOutput")) {
			dataOutput = new MetaDataOutput();
			dataOutput.fromJSON(json.getJSONObject("dataOutput"));
		}
	}

}
