package com.bokesoft.yigo.meta.bpm.process.attribute.parameter;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQueryParameterCollection;

public class MetaSqlQueryParameter extends MetaBasicParameter {
	
	public static final String TAG_NAME = "SqlQueryParameter";
	
	private String SQL = "";
	
	private MetaQueryParameterCollection queryParameterCollection;
	
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] { queryParameterCollection });
	}
	
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaQueryParameterCollection.TAG_NAME)) {
			queryParameterCollection = new MetaQueryParameterCollection();
			resultMetaObject = queryParameterCollection;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public String getSQL() {
		return SQL;
	}

	public void setSQL(String sQL) {
		SQL = sQL;
	}
	
	public MetaQueryParameterCollection getQueryParameterCollection() {
		return queryParameterCollection;
	}
	
	public void setQueryParameterCollection(MetaQueryParameterCollection queryParameterCollection) {
		this.queryParameterCollection = queryParameterCollection;
	}
	
	@Override
	public JSONObject toJSON() {
		return null;
	}

	@Override
	public void fromJSON(JSONObject json) {

	}

	@Override
	public AbstractMetaObject clone() {
		MetaSqlQueryParameter query = (MetaSqlQueryParameter) newInstance();
		query.setSQL(SQL);
		query.setQueryParameterCollection(queryParameterCollection == null ? null : (MetaQueryParameterCollection) queryParameterCollection.clone());
		return query;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSqlQueryParameter();
	}

}
