package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.common.def.SwimlineDirection;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.AbstractBPMElement;

public class MetaSwimline extends AbstractBPMElement {

	public static final String TAG_NAME = "Swimline";

	private String direction = SwimlineDirection.STR_VERTICAL;
	
	private MetaSwimlinePosition position = null;
	
	private MetaSwimlineSize size = null;

	/**
	 * @return the direction
	 */
	public String getDirection() {
		return direction;
	}

	/**
	 * @param direction
	 *            the direction to set
	 */
	public void setDirection(String direction) {
		this.direction = direction;
	}
	
	/**
	 * @return the position
	 */
	public MetaSwimlinePosition getPosition() {
		return position;
	}

	/**
	 * @param position
	 *            the position to set
	 */
	public void setPosition(MetaSwimlinePosition position) {
		this.position = position;
	}

	/**
	 * @return the size
	 */
	public MetaSwimlineSize getSize() {
		return size;
	}

	/**
	 * @param size
	 *            the size to set
	 */
	public void setSize(MetaSwimlineSize size) {
		this.size = size;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaSwimline newSwimline = (MetaSwimline) newInstance();
		newSwimline.setDirection(direction);
		newSwimline.setPosition(position == null ? null : (MetaSwimlinePosition) position.clone());
		newSwimline.setSize(size == null ? null : (MetaSwimlineSize) size.clone());
		return newSwimline;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSwimline();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("key", getKey());
		obj.put("caption", getCaption());
		obj.put("direction", direction);
		obj.put("positionX", position == null ? 0 : position.getX());
		obj.put("positionY", position == null ? 0 : position.getY());
		obj.put("width", size == null ? 0 : size.getWidth());
		obj.put("height", size == null ? 0 : size.getHeight());
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		setKey(json.optString("key"));
		setCaption(json.optString("caption"));
		this.direction = json.optString("direction");
		if (position == null)
			position = new MetaSwimlinePosition();
		this.position.setX(json.optInt("positionX"));
		this.position.setY(json.optInt("positionY"));
		if (size == null)
			size = new MetaSwimlineSize();
		this.size.setWidth(json.optInt("width"));
		this.size.setHeight(json.optInt("height"));
	}

}
