package com.bokesoft.yigo.meta.base;

import java.util.Iterator;
import java.util.Map.Entry;
import java.util.function.Consumer;

import com.bokesoft.yes.common.struct.StringLinkedHashMap;

public abstract class GenericKeyPairCompositeCollection	extends KeyPairCompositeObject implements Iterable<KeyPairCompositeObject> {
	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private StringLinkedHashMap<KeyPairCompositeObject> elementMap = null;

	public StringLinkedHashMap<KeyPairCompositeObject> getChild() {
		return elementMap;
	}

	public GenericKeyPairCompositeCollection() {
		elementMap = new StringLinkedHashMap<KeyPairCompositeObject>();
	}

	public void add(KeyPairCompositeObject element) {
		synchronized(elementMap) {
			elementMap.put(element.getKey(), element);
		}
	}

	public void remove(String key) {
		synchronized(elementMap) {
			elementMap.remove(key);
		}
	}

	public KeyPairCompositeObject get(String key) {
		synchronized(elementMap) {
			return elementMap.get(key);
		}
	}

	public boolean contains(String key) {
		synchronized(elementMap) {
			return elementMap.containsKey(key);
		}
	}

	public int size() {
		synchronized(elementMap) {
			return elementMap.size();
		}
	}

	public Iterator<KeyPairCompositeObject> iterator() {
		synchronized(elementMap) {
			return elementMap.values().iterator();
		}
	}

	public void clear() {
		synchronized(elementMap) {
			this.elementMap.clear();
		}
	}

	@Override
	public boolean needPreLoad() {
		return true;
	}

	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc, Object node,
										   Object flag, int runType) throws MetaException {
		Iterator<Entry<String, KeyPairCompositeObject>> itEntry = elementMap.entrySet().iterator();
		Entry<String, KeyPairCompositeObject> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			KeyPairCompositeObject element = entry.getValue();
			Object childNode = env.prepare(element, node);
			element.traversal(env, doc, childNode, flag, runType);
		}
	}

	@Override
	public AbstractMetaObject clone() {
		GenericKeyPairCompositeCollection newObject = (GenericKeyPairCompositeCollection)newInstance();
		Iterator<Entry<String, KeyPairCompositeObject>> itEntry = elementMap.entrySet().iterator();
		Entry<String, KeyPairCompositeObject> entry = null;
		while (itEntry.hasNext()) {
			entry = itEntry.next();
			newObject.add((KeyPairCompositeObject)entry.getValue().clone());
		}
		return newObject;
	}

	public void forEach(Consumer<? super KeyPairCompositeObject> action) {
		synchronized(elementMap) {
			elementMap.values().forEach(action);
		}
	}
}
