package com.bokesoft.yigo.meta.base;

import java.util.ArrayList;
import java.util.Iterator;

/**
 * GenericCompositeCollection定义复合结构中集合类的基类
 * @author 王元和
 *
 */
public abstract class GenericCompositeCollection extends AbstractCompositeObject {
	protected ArrayList<AbstractCompositeObject> elementArray = null;
	public GenericCompositeCollection() {
		super();
		elementArray = new ArrayList<AbstractCompositeObject>();
	}
	
	public void add(AbstractCompositeObject element) {
		elementArray.add(element);
	}
	
	public int indexOf(AbstractCompositeObject element) {
		return elementArray.indexOf(element);
	}

	public void add(int index, AbstractCompositeObject element) {
		elementArray.add(index, element);
	}
	
	public void remove(AbstractCompositeObject element) {
		elementArray.remove(element);
	}
	
	public void remove(int index) {
		elementArray.remove(index);
	}
	
	public void clear() {
		this.elementArray.clear();
	}
	
	public int size() {
		return elementArray.size();
	}
	
	public AbstractCompositeObject get(int index) {
		return elementArray.get(index);
	}
	
	public Iterator<AbstractCompositeObject> iterator() {
		return elementArray.iterator();
	}
	
	@Override
	public void traversalCollectionObjects(IMetaEnv env, Object doc, Object node, Object flag, int runType) throws MetaException {
		Iterator<AbstractCompositeObject> itElement = elementArray.iterator();
		AbstractCompositeObject element = null;
		while ( itElement.hasNext() ) {
			element = itElement.next();
			Object childNode = env.prepare(element, node);
			element.traversal(env, doc, childNode, flag, runType);
		}
	}
	
	@Override
	public AbstractMetaObject clone() {
		GenericCompositeCollection newObject = (GenericCompositeCollection)newInstance();
		Iterator<AbstractCompositeObject> it = elementArray.iterator();
		AbstractCompositeObject childObject = null;
		while ( it.hasNext() ) {
			childObject = it.next();
			newObject.add((AbstractCompositeObject)childObject.clone());
		}
		return newObject;
	}
}
