package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.solution.MetaProjectItem;

public class MetaProjectItemAction extends BaseDomAction<AbstractMetaObject> {

	@Override
	public void load(Document document, Element element, AbstractMetaObject meta, int runType) {
		MetaProjectItem metaProjectItem = (MetaProjectItem)meta;
		metaProjectItem.setKey(DomHelper.readAttr(element, "Key", ""));
		metaProjectItem.setCaption(DomHelper.readAttr(element, "Caption", ""));
	}

	@Override
	public void save(Document document, Element element, AbstractMetaObject meta, int runType) {
		MetaProjectItem metaProjectItem = (MetaProjectItem)meta;
		DomHelper.writeAttr(element, "Key", metaProjectItem.getKey(), "");
		DomHelper.writeAttr(element, "Caption", metaProjectItem.getCaption(), "");
	}

}
