package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.GlobalI18N;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.strings.MetaStringTableProfile;

public class MetaProcessI18NScanLoad extends BaseMetaScanLoad {
	private GlobalI18N globalI18N = null;
	public MetaProcessI18NScanLoad(GlobalI18N globalI18N, IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.BPM_FOLD, context);
		this.globalI18N = globalI18N;
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		// processKey-lang.xml
		int firstIndex = fileName.indexOf('-');
		int secondIndex = fileName.lastIndexOf('.');
		String lang = fileName.substring(firstIndex + 1, secondIndex);
		String processKey = fileName.substring(0, firstIndex);
		
		MetaStringTableProfile profile = new MetaStringTableProfile();
		profile.setKey(processKey);
		profile.setFilePath(filePath);
		profile.setLang(lang);
		profile.setResolver(resolver);
		
		globalI18N.addProcessProfile(processKey, profile);
	}

}
