package com.bokesoft.yes.meta.persist.dom.solution;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import org.json.JSONObject;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaExcelTemplateScanLoad extends BaseMetaScanLoad {
	private MetaExcelTemplateList excelTemplateList = null;
	
	List<MetaExcelTemplateProfile> list = null;
	public MetaExcelTemplateScanLoad(MetaExcelTemplateList excelTemplateList, IMetaResolver resolver,
			MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.EXCELTEMPLATE_FOLD, context);
		this.excelTemplateList = excelTemplateList;
		list = new CopyOnWriteArrayList<>();
	}
	
	protected void postLoad() throws Throwable{
		super.postLoad();
		merge();
	}
	
	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName)
			throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaExcelWorkbook.TAG_NAME.equals(tagName)) {
				MetaExcelTemplateProfile profile = new MetaExcelTemplateProfile();
				profile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				profile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				profile.setProject(metaProject);
				profile.setResource(filePath);
				list.add(profile);
			}
		}
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaExcelTemplateProfile profile) {
		
	}

	private void merge() {
		if(list.isEmpty()) {
			return;
		}
		try {
			String projectKey;
			for(MetaExcelTemplateProfile profile : list) {
				projectKey = profile.getProject().getKey();
				MetaExcelTemplateSubList subList = excelTemplateList.get(projectKey);
				if(subList == null) {
					subList = new MetaExcelTemplateSubList();
					subList.setKey(projectKey);
				}
				subList.add(profile);
				excelTemplateList.add(subList);
			}
		}finally {
			list.clear();
		}
	}
	
	public MetaExcelTemplateList getMetaExcelTemplateList() {
		merge();
		return this.excelTemplateList;
	}
}