package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EncryptType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;

public class MetaLoginSettingAction extends BaseDomAction<MetaLoginSetting> {

	@Override
	public void load(Document document, Element element, MetaLoginSetting meta,
			int runType) {
		meta.setNormalAppLogin(DomHelper.readAttr(element, MetaConstants.LOGIN_NORMALAPP, ""));
		meta.setLoginProcess(DomHelper.readAttr(element, MetaConstants.LOGIN_PROCESS, ""));
		meta.setLogoutProcess(DomHelper.readAttr(element, MetaConstants.LOGOUT_PROCESS, ""));
		meta.setChangePwdProcess(DomHelper.readAttr(element, MetaConstants.CHANGE_PWD_PROCESS, ""));
		meta.setOvertimeProcess(DomHelper.readAttr(element, MetaConstants.LOGIN_OVERTIME_PROCESS, ""));
		meta.setSessionPara(DomHelper.readAttr(element, MetaConstants.LOGIN_SESSIONPARA, false));
		meta.setMultiLang(DomHelper.readAttr(element, MetaConstants.LOGIN_MULTILANG, false));
		meta.setSSOProvider(DomHelper.readAttr(element, MetaConstants.LOGIN_SSOPROVIDER, ""));
		meta.setEncryptType(EncryptType.parse(DomHelper.readAttr(element, MetaConstants.LOGIN_ENCRYPT_TYPE, EncryptType.STR_RSA)));
	}

	@Override
	public void save(Document document, Element element, MetaLoginSetting meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.LOGIN_NORMALAPP, meta.getNormalAppLogin(), "");
		DomHelper.writeAttr(element, MetaConstants.LOGIN_PROCESS, meta.getLoginProcess(), "");
		DomHelper.writeAttr(element, MetaConstants.LOGOUT_PROCESS, meta.getLogoutProcess(), "");
		DomHelper.writeAttr(element, MetaConstants.CHANGE_PWD_PROCESS, meta.getChangePwdProcess(), "");
		DomHelper.writeAttr(element, MetaConstants.LOGIN_OVERTIME_PROCESS, meta.getOvertimeProcess(), "");
		DomHelper.writeAttr(element, MetaConstants.LOGIN_SESSIONPARA, meta.isSessionPara(), false);
		DomHelper.writeAttr(element, MetaConstants.LOGIN_MULTILANG, meta.isMultiLang(), false);
		DomHelper.writeAttr(element, MetaConstants.LOGIN_SSOPROVIDER, meta.getSSOProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.LOGIN_ENCRYPT_TYPE, EncryptType.toString(meta.getEncryptType()), EncryptType.STR_RSA);
	}

}
