package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaBPMMColumn;

public class MetaBPMMColumnAction extends BaseDomAction<MetaBPMMColumn> {

	@Override
	public void load(Document document, Element element, MetaBPMMColumn meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDefaultValue(DomHelper.readAttr(element, MetaConstants.COMMON_DEFAULTVALUE, ""));
		meta.setDBColumnName(DomHelper.readAttr(element, MetaConstants.COLUMN_DBCOLUMNNAME, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "-1")));
		int defaultLength = meta.getDataType() == DataType.STRING ? 255 : 0;
		meta.setLength(DomHelper.readAttr(element, MetaConstants.COLUMN_DEF_LENGTH, defaultLength));
		int defaultPrecision = meta.getDataType() == DataType.NUMERIC ? 16 : 0;
		meta.setPrecision(DomHelper.readAttr(element, MetaConstants.COLUMN_DEF_PRECISION, defaultPrecision));
		int defaultScale = meta.getDataType() == DataType.NUMERIC ? 2 : 0;
		meta.setScale(DomHelper.readAttr(element, MetaConstants.COLUMN_DEF_SCALE, defaultScale));
	}

	@Override
	public void save(Document document, Element element, MetaBPMMColumn meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DBCOLUMNNAME, meta.getDBColumnName(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DATATYPE, DataType.toString(meta.getDataType()), "-1");
		int length = meta.getDataType() == DataType.STRING ? meta.getLength() : 0;
		int defaultLength = meta.getDataType() == DataType.STRING ? 255 : 0;
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DEF_LENGTH, length, defaultLength);
		if (meta.getDataType() == DataType.NUMERIC) {
			int precision = meta.getDataType() == DataType.NUMERIC ? meta.getPrecision() : 0;
			element.setAttribute(MetaConstants.COLUMN_DEF_PRECISION, Integer.toString(precision));
			int scale = meta.getDataType() == DataType.NUMERIC ? meta.getScale() : 0;
			element.setAttribute(MetaConstants.COLUMN_DEF_SCALE, Integer.toString(scale));
		}
	}

}
