package com.bokesoft.yes.meta.persist.dom.report;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.PlotOrientation;
import com.bokesoft.yigo.common.def.PrintOrderType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportConstants;

public class MetaReportAction extends BaseDomAction<MetaReport> {

	@Override
	public void load(Document document, Element element, MetaReport meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setFormKey(DomHelper.readAttr(element, MetaReportConstants.FORM_KEY, ""));
		meta.setGroup(DomHelper.readAttr(element, MetaReportConstants.REPORT_GROUP, ""));
		meta.setDefault(DomHelper.readAttr(element, MetaReportConstants.REPORT_DEFAULT, true));
		meta.setVirtualPage(DomHelper.readAttr(element, MetaReportConstants.REPORT_VIRTUAL_PAGE, false));
		meta.setPageID(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAGEID, "A4"));
		meta.setPageWidth(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAGE_WIDTH, 595));
		meta.setPageHeight(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAGE_HEIGHT, 842));
		meta.setPaperID(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAPERID, "A4"));
		meta.setPaperWidth(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAPER_WIDTH, 595));
		meta.setPaperHeight(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAPER_HEIGHT, 842));
		meta.setLeftMargin(DomHelper.readAttr(element, MetaReportConstants.REPORT_LEFT_MARGIN, 0));
		meta.setTopMargin(DomHelper.readAttr(element, MetaReportConstants.REPORT_TOP_MARGIN, 0));
		meta.setRightMargin(DomHelper.readAttr(element, MetaReportConstants.REPORT_RIGHT_MARGIN, 0));
		meta.setBottomMargin(DomHelper.readAttr(element, MetaReportConstants.REPORT_BOTTOM_MARGIN, 0));
		meta.setPageOrientation(PlotOrientation.parse(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAGE_ORIENTATION, PlotOrientation.STR_Portrait)));
		meta.setPaperOrientation(PlotOrientation.parse(DomHelper.readAttr(element, MetaReportConstants.REPORT_PAPER_ORIENTATION, PlotOrientation.STR_Portrait)));
		meta.setPrintOrderType(PrintOrderType.parse(DomHelper.readAttr(element, MetaReportConstants.REPORT_PRINTORDERTYPE, PrintOrderType.STR_PrimaryMixed)));
	}

	@Override
	public void save(Document document, Element element, MetaReport meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaReportConstants.FORM_KEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_GROUP, meta.getGroup(), "");
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_DEFAULT, meta.isDefault(), true);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_VIRTUAL_PAGE, meta.isVirtualPage(), false);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAGEID, meta.getPageID(), "");
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAGE_WIDTH, meta.getPageWidth(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAGE_HEIGHT, meta.getPageHeight(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAPERID, meta.getPaperID(), "");
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAPER_WIDTH, meta.getPaperWidth(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAPER_HEIGHT, meta.getPaperHeight(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_LEFT_MARGIN, meta.getLeftMargin(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_TOP_MARGIN, meta.getTopMargin(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_RIGHT_MARGIN, meta.getRightMargin(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_BOTTOM_MARGIN, meta.getBottomMargin(), 0);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAGE_ORIENTATION, PlotOrientation.toString(meta.getPageOrientation()), PlotOrientation.STR_Portrait);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PAPER_ORIENTATION, PlotOrientation.toString(meta.getPaperOrientation()), PlotOrientation.STR_Portrait);
		DomHelper.writeAttr(element, MetaReportConstants.REPORT_PRINTORDERTYPE, PrintOrderType.toString(meta.getPrintOrderType()), PrintOrderType.STR_PrimaryMixed);
	}
}
