package com.bokesoft.yes.meta.persist.dom.mapping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mapping.MetaMapping;

public class MetaMappingAction extends BaseDomAction<MetaMapping> {

	@Override
	public void load(Document document, Element element, MetaMapping meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaMappingConstants.IMPL, ""));
		
	}

	@Override
	public void save(Document document, Element element, MetaMapping meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.IMPL, meta.getImpl(), "");
	}

	
}
