package com.bokesoft.yes.meta.persist.dom.form.component.panel.gridpanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.panel.MetaPanelAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaGridLayoutPanel;

public class MetaGridLayoutPanelAction extends MetaPanelAction<MetaGridLayoutPanel> {

	@Override
	public void load(Document document, Element element,
			MetaGridLayoutPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setOddColumnColor(DomHelper.readAttr(element, MetaConstants.GRIDLAYOUTPANEL_ODDCOLUMNCOLOR, ""));
		meta.setForceLayout(DomHelper.readAttr(element, MetaConstants.GRIDLAYOUTPANEL_FORCELAYOUT, true));
	}

	@Override
	public void save(Document document, Element element,
			MetaGridLayoutPanel meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.GRIDLAYOUTPANEL_ODDCOLUMNCOLOR, meta.getOddColumnColor(), "");
		DomHelper.writeAttr(element, MetaConstants.GRIDLAYOUTPANEL_FORCELAYOUT, meta.isForceLayout(), true);
	}
	
}
