package com.bokesoft.yes.meta.persist.dom.form.component.panel.collapsepanel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.panel.MetaPanelExtAction;
import com.bokesoft.yigo.common.def.CollapseType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.collapsepanel.MetaCollapsePanel;

/**
 * 分页布局面板在保存和载入时的相关动作
 * 
 * @author my
 * @since YES1.0
 */
public class MetaCollapsePanelExtAction extends MetaPanelExtAction<MetaCollapsePanel> {
	@Override
	public void load(Document document, Element element, MetaCollapsePanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setCollapseType(CollapseType.parse(DomHelper.readAttr(element, MetaConstants.COLLAPSE_TYPE, "")));
	}

	@Override
	public void save(Document document, Element element, MetaCollapsePanel meta, int runType) {
		
	}
}
