package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;

/**
 * 分页布局面板在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaTabPanelExtAction extends MetaPanelExtAction<MetaTabPanel> {
	@Override
	public void load(Document document, Element element, MetaTabPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTabPosition(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_TABPOSITION, "")));
		meta.setTabMode(TabMode.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_TABMODE, "")));
		meta.setIndicatorHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.TABPANEL_INDICATORHEIGHT, null)));
		meta.setIndicatorColor(DomHelper.readAttr(element, MetaConstants.TABPANEL_INDICATORCOLOR, null));
		meta.setShowHead(DomHelper.readBool(element, MetaConstants.TABPANEL_SHOWHEAD, null));
		meta.setHoverHead(DomHelper.readBool(element, MetaConstants.TABPANEL_HOVERHEAD, null));
	}

	@Override
	public void save(Document document, Element element, MetaTabPanel meta, int runType) {
		
	}
}
