package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaTrace;

public class MetaTraceAction extends MetaBaseScriptAction<MetaTrace> {
	
	@Override
	public void load(Document document, Element element, MetaTrace meta,
			int runType) {
		super.load(document, element, meta, runType);
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCondition(DomHelper.readAttr(element, MetaConstants.CONDITION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTrace meta,
			int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION, meta.getCondition(), "");
	}

}
