package com.bokesoft.yes.meta.persist.dom.form.component.control.refresh;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshControl;

public class MetaRefreshControlAction extends MetaComponentAction<MetaRefreshControl> {
	public MetaRefreshControlAction() {
		super();
	}

	@Override
	public void load(Document document, Element element, MetaRefreshControl meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setOrientation(OrientationType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.STR_Vertical)));
	}

	@Override
	public void save(Document document, Element element, MetaRefreshControl meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_ORIENTATION, OrientationType.toString(meta.getOrientation()), OrientationType.STR_Vertical);
	}
}
