package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUploadButtonProperties;

public class MetaUploadButtonPropertiesAction extends DomPropertiesAction<MetaUploadButtonProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaUploadButtonProperties meta, int runType) {
		meta.setMaxSize(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_MAXSIZE, -1));
		meta.setAllowedTypes(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_ALLOWEDTYPES, ""));
		meta.setDeleteOld(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_DELETEOLD, false));
		meta.setMultiFile(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_ISMULTIFILE, false));
		meta.setPostProcess(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_POSTPROCESS, ""));
		meta.setProvider(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_PROVIDER, ""));
		meta.setAllowedTypesFormula(DomHelper.readAttr(element, MetaConstants.UPLOADBUTTON_ALLOWEDTYPESFORMULA, ""));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaUploadButtonProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_MAXSIZE, meta.getMaxSize(), -1);
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_ALLOWEDTYPES, meta.getAllowedTypes(), "");
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_DELETEOLD, meta.isDeleteOld(), false);
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_ISMULTIFILE, meta.isMultiFile(), false);
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_POSTPROCESS, meta.getPostProcess(), "");
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_PROVIDER, meta.getProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.UPLOADBUTTON_ALLOWEDTYPESFORMULA, meta.getAllowedTypesFormula(), "");
	}


}
