package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.common.def.FormatStyle;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;

public class MetaNumberEditorPropertiesAction extends DomPropertiesAction<MetaNumberEditorProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaNumberEditorProperties meta, int runType) {
		meta.setPrecision(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_PRECISION, 16));
		meta.setScale(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SCALE, 2));
		meta.setIntegerValue(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_INTEGERVALUE, false));
		meta.setUseGroupingSeparator(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_USEGROUPINGSEPARATOR, true));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TEXT_PROMPTTEXT, ""));
		meta.setSelectOnFocus(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SELECTONFOCUS, true));
		meta.setRoundingMode(RoundingMode.parse(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_ROUNDINGMODE, RoundingMode.STR_HALF_UP)));
		meta.setZeroString(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_ZEROSTRING, ""));
		meta.setNegtiveForeColor(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_NEGTIVEFORECOLOR, ""));
		meta.setShowZero(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SHOWZERO, false));
		meta.setFormatStyle(FormatStyle.parse(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_FORMATSTYLE, "")));
		meta.setImeOptions(EditorImeOptions.parse(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_IMEOPTIONS, "")));
		meta.setStripTrailingZeros(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_STRIPTRAILINGZEROS, false));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.NUMBEREDITOR_DISABLEKEYBOARD, null));
		meta.setSuffix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_SUFFIX, ""));
		meta.setPrefix(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_PREFIX, ""));
		meta.setFormulaText(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_FORMULATEXT, ""));
		meta.setAllowNull(DomHelper.readAttr(element, MetaConstants.NUMBEREDITOR_ALLOWNULL, false));
		// 移动端特殊处理
		if (element.hasAttribute(MetaConstants.TEXT_SELECTONFOCUS)) {
			meta.setMobileSelectOnFocus(Boolean.parseBoolean(element.getAttribute(MetaConstants.TEXT_SELECTONFOCUS)));
		}
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaNumberEditorProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_PRECISION, meta.getPrecision(), 16);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_SCALE, meta.getScale(), 2);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_INTEGERVALUE, meta.integerValue(), false);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_USEGROUPINGSEPARATOR, meta.isUseGroupingSeparator(), true);
		DomHelper.writeAttr(element, MetaConstants.TEXT_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_SELECTONFOCUS, meta.isSelectOnFocus(), true);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_ROUNDINGMODE, RoundingMode.toString(meta.getRoundingMode()), RoundingMode.STR_HALF_UP);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_ZEROSTRING, meta.getZeroString(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_NEGTIVEFORECOLOR, meta.getNegtiveForeColor(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_SHOWZERO, meta.isShowZero(), false);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_FORMATSTYLE, FormatStyle.format(meta.getFormatStyle()), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_IMEOPTIONS,EditorImeOptions.toString(meta.getImeOptions()), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_STRIPTRAILINGZEROS, meta.getStripTrailingZeros(), false);
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_SUFFIX, meta.getSuffix(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_PREFIX, meta.getPrefix(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_FORMULATEXT, meta.getFormulaText(), "");
		DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_ALLOWNULL, meta.getAllowNull(), false);
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.NUMBEREDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard().toString(), "");
		}
	}

}
